/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.redis.fluent.AsyncOperationStatusClient;
import com.azure.resourcemanager.redis.fluent.FirewallRulesClient;
import com.azure.resourcemanager.redis.fluent.LinkedServersClient;
import com.azure.resourcemanager.redis.fluent.OperationsClient;
import com.azure.resourcemanager.redis.fluent.PatchSchedulesClient;
import com.azure.resourcemanager.redis.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.redis.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.redis.fluent.RedisClient;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.implementation.AsyncOperationStatusClientImpl;
import com.azure.resourcemanager.redis.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.redis.implementation.LinkedServersClientImpl;
import com.azure.resourcemanager.redis.implementation.OperationsClientImpl;
import com.azure.resourcemanager.redis.implementation.PatchSchedulesClientImpl;
import com.azure.resourcemanager.redis.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.redis.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.redis.implementation.RedisClientImpl;
import com.azure.resourcemanager.redis.implementation.RedisManagementClientBuilder;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=RedisManagementClientBuilder.class)
public final class RedisManagementClientImpl
extends AzureServiceClient
implements RedisManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final RedisClient redis;
    private final FirewallRulesClient firewallRules;
    private final PatchSchedulesClient patchSchedules;
    private final LinkedServersClient linkedServers;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final AsyncOperationStatusClient asyncOperationStatus;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public RedisClient getRedis() {
        return this.redis;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public PatchSchedulesClient getPatchSchedules() {
        return this.patchSchedules;
    }

    @Override
    public LinkedServersClient getLinkedServers() {
        return this.linkedServers;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public AsyncOperationStatusClient getAsyncOperationStatus() {
        return this.asyncOperationStatus;
    }

    RedisManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-06-01";
        this.operations = new OperationsClientImpl(this);
        this.redis = new RedisClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.patchSchedules = new PatchSchedulesClientImpl(this);
        this.linkedServers = new LinkedServersClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.asyncOperationStatus = new AsyncOperationStatusClientImpl(this);
    }
}

