/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.ProviderResourceTypesClient;
import com.azure.resourcemanager.resources.fluent.models.ProviderResourceTypeListResultInner;
import com.azure.resourcemanager.resources.implementation.ResourceManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ProviderResourceTypesClientImpl
implements ProviderResourceTypesClient {
    private final ProviderResourceTypesService service;
    private final ResourceManagementClientImpl client;

    ProviderResourceTypesClientImpl(ResourceManagementClientImpl client) {
        this.service = (ProviderResourceTypesService)RestProxy.create(ProviderResourceTypesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ProviderResourceTypeListResultInner>> listWithResponseAsync(String resourceProviderNamespace, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProviderResourceTypeListResultInner>> listWithResponseAsync(String resourceProviderNamespace, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProviderResourceTypeListResultInner> listAsync(String resourceProviderNamespace, String expand) {
        return this.listWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> Mono.justOrEmpty((Object)((ProviderResourceTypeListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProviderResourceTypeListResultInner> listAsync(String resourceProviderNamespace) {
        String expand = null;
        return this.listWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> Mono.justOrEmpty((Object)((ProviderResourceTypeListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProviderResourceTypeListResultInner list(String resourceProviderNamespace) {
        String expand = null;
        return (ProviderResourceTypeListResultInner)this.listAsync(resourceProviderNamespace, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProviderResourceTypeListResultInner> listWithResponse(String resourceProviderNamespace, String expand, Context context) {
        return (Response)this.listWithResponseAsync(resourceProviderNamespace, expand, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ResourceManagementCl")
    private static interface ProviderResourceTypesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/resourceTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderResourceTypeListResultInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="$expand") String var2, @PathParam(value="resourceProviderNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

