/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MissingPermissionsTest
extends BaseJDBCTestCase {
    private static final String AUTH_MSG = "derby.connection.requireAuthentication";
    private static final String SYSTEM_HOME = "derby.system.home";
    private static final String resourcePrefix = "unitTests/junit/";
    private static final String testPrefix = "org/apache/derbyTesting/unitTests/junit/";
    private static final String OK_POLICY = "MissingPermissionsTest.policy";
    private static final String OK_POLICY_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest.policy";
    private static final String OK_POLICY_R = "unitTests/junit/MissingPermissionsTest.policy";
    private static final String POLICY_MINUS_PROPERTYPERMISSION = "MissingPermissionsTest1.policy";
    private static final String POLICY_MINUS_PROPERTYPERMISSION_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest1.policy";
    private static final String POLICY_MINUS_FILEPERMISSION = "MissingPermissionsTest2.policy";
    private static final String POLICY_MINUS_FILEPERMISSION_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest2.policy";
    private static final String POLICY_MINUS_FILEPERMISSION_R = "unitTests/junit/MissingPermissionsTest2.policy";
    private final int KIND_EXPECT_ERROR_MSG_PRESENT = 0;
    private final int KIND_EXPECT_ERROR_MSG_ABSENT = 1;
    private static boolean inSubProcess = false;

    public MissingPermissionsTest(String name) {
        super(name);
    }

    private static Test makeTest(String fixture, String policy) {
        Object t = new MissingPermissionsTest(fixture);
        t = new SecurityManagerSetup((Test)t, policy);
        Properties props = new Properties();
        props.setProperty(AUTH_MSG, "true");
        props.setProperty("derby.database.sqlAuthorization", "true");
        props.setProperty("derby.authentication.provider", "BUILTIN");
        props.setProperty("derby.user.APP", "APPPW");
        t = new SystemPropertyTestSetup((Test)t, props, true);
        t = TestConfiguration.changeUserDecorator((Test)t, "APP", "APPPW");
        t = TestConfiguration.singleUseDatabaseDecorator((Test)t);
        return t;
    }

    public static Test suite() {
        inSubProcess = Boolean.getBoolean("inSubProcess");
        BaseTestSuite suite = new BaseTestSuite("SystemPrivilegesPermissionTest");
        if (!inSubProcess && !TestConfiguration.loadingFromJars()) {
            return suite;
        }
        if (!inSubProcess) {
            suite.addTest((Test)new SupportFilesSetup(MissingPermissionsTest.makeTest("testMissingFilePermission", POLICY_MINUS_FILEPERMISSION_T), new String[]{POLICY_MINUS_FILEPERMISSION_R}));
            suite.addTest(MissingPermissionsTest.makeTest("testPresentPropertiesPermission", OK_POLICY_T));
            suite.addTest(MissingPermissionsTest.makeTest("testMissingPropertiesPermission", POLICY_MINUS_PROPERTYPERMISSION_T));
        }
        suite.addTest((Test)new SupportFilesSetup(MissingPermissionsTest.makeTest("testModifyThreadGroup", OK_POLICY_T), new String[]{OK_POLICY_R}));
        return suite;
    }

    public void testPresentPropertiesPermission() throws SQLException, IOException, PrivilegedActionException {
        this.openDefaultConnection("APP", "APPPW").close();
        try (Connection c = null;){
            c = this.openDefaultConnection("Donald", "Duck");
            MissingPermissionsTest.fail();
        }
        this.verifyMessagesInDerbyLog(1);
    }

    public void testMissingPropertiesPermission() throws SQLException, IOException, PrivilegedActionException {
        this.openDefaultConnection("APP", "APPPW").close();
        this.openDefaultConnection("Donald", "Duck").close();
        this.verifyMessagesInDerbyLog(0);
    }

    public void testMissingFilePermission() throws SQLException, IOException, PrivilegedActionException, ClassNotFoundException, InterruptedException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-Djava.security.manager");
        args.add("-Djava.security.policy=extin/MissingPermissionsTest2.policy");
        args.add("-DderbyTesting.engine=" + MissingPermissionsTest.getSystemProperty("derbyTesting.engine"));
        args.add("-DderbyTesting.tools=" + MissingPermissionsTest.getSystemProperty("derbyTesting.tools"));
        args.add("-DderbyTesting.testing=" + MissingPermissionsTest.getSystemProperty("derbyTesting.testing"));
        args.add("-DderbyTesting.shared=" + MissingPermissionsTest.getSystemProperty("derbyTesting.shared"));
        args.add("-DderbyTesting.junit=" + MissingPermissionsTest.getSystemProperty("derbyTesting.junit"));
        String antjunit = MissingPermissionsTest.getSystemProperty("derbyTesting.antjunit");
        if (antjunit != null) {
            args.add("-DderbyTesting.antjunit=" + antjunit);
        }
        args.add("-Dderby.system.home=system/nested");
        args.add("-Dij.connection.test=jdbc:derby:wombat;create=true");
        args.add("org.apache.derby.tools.ij");
        String[] argArray = args.toArray(new String[0]);
        Process p = MissingPermissionsTest.execJavaCmd(argArray);
        SpawnedProcess spawned = new SpawnedProcess(p, "MPT");
        spawned.suppressOutputOnComplete();
        p.getOutputStream().close();
        int exitCode = spawned.complete(120000L);
        MissingPermissionsTest.assertTrue((String)spawned.getFailMessage("subprocess run failed: "), (exitCode == 0 ? 1 : 0) != 0);
        String expectedMessageOnConsole = "(?s).*The file or directory system.nested could not be created due to a security exception: java\\.security\\.AccessControlException: [Aa]ccess denied \\(\"?java\\.io\\.FilePermission\"? \"?system.nested\"? \"?write\"?\\).*";
        String output = spawned.getFullServerOutput();
        String err = spawned.getFullServerError();
        MissingPermissionsTest.assertTrue((err.contains("java.security.AccessControlException") && err.contains("ccess denied") && err.contains("java.io.FilePermission") && err.contains("system") && err.contains("nested") && err.contains("write") ? 1 : 0) != 0);
    }

    private String makeMessage(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append("(?s).*WARNING: the property ");
        sb.append(Pattern.quote(property));
        sb.append(" could not be read due to a security exception: ");
        sb.append("java\\.security\\.AccessControlException: [Aa]ccess denied \\(");
        sb.append("\"?java\\.util\\.PropertyPermission\"? \"?");
        sb.append(Pattern.quote(property));
        sb.append("\"? \"?read\"?.*");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMessagesInDerbyLog(int kind) throws FileNotFoundException, IOException, PrivilegedActionException {
        String derbyLog = null;
        if (kind == 0) {
            derbyLog = "derby.log";
        } else if (kind == 1) {
            derbyLog = "system/derby.log";
        }
        StringBuilder log = new StringBuilder();
        try (BufferedReader dl = MissingPermissionsTest.getReader(derbyLog);){
            String line = dl.readLine();
            while (line != null) {
                log.append(line);
                log.append('\n');
                line = dl.readLine();
            }
            String logString = log.toString();
            if (kind == 0) {
                MissingPermissionsTest.assertTrue((String)logString, (boolean)logString.matches(this.makeMessage(AUTH_MSG)));
                MissingPermissionsTest.assertTrue((String)logString, (boolean)logString.matches(this.makeMessage(SYSTEM_HOME)));
            } else if (kind == 1) {
                MissingPermissionsTest.assertFalse((String)logString, (boolean)logString.matches(this.makeMessage(AUTH_MSG)));
                MissingPermissionsTest.assertFalse((String)logString, (boolean)logString.matches(this.makeMessage(SYSTEM_HOME)));
            }
        }
    }

    private static BufferedReader getReader(final String file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedReader>(){

            @Override
            public BufferedReader run() throws FileNotFoundException {
                return new BufferedReader(new FileReader(file));
            }
        });
    }

    public void testModifyThreadGroup() throws Throwable {
        if (!inSubProcess) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add("-DinSubProcess=true");
            args.add("-Djava.security.manager");
            args.add("-Djava.security.policy=extin/MissingPermissionsTest.policy");
            args.add("-DderbyTesting.engine=" + MissingPermissionsTest.getSystemProperty("derbyTesting.engine"));
            args.add("-DderbyTesting.tools=" + MissingPermissionsTest.getSystemProperty("derbyTesting.tools"));
            args.add("-DderbyTesting.testing=" + MissingPermissionsTest.getSystemProperty("derbyTesting.testing"));
            args.add("-DderbyTesting.shared=" + MissingPermissionsTest.getSystemProperty("derbyTesting.shared"));
            args.add("-DderbyTesting.junit=" + MissingPermissionsTest.getSystemProperty("derbyTesting.junit"));
            String antjunit = MissingPermissionsTest.getSystemProperty("derbyTesting.antjunit");
            if (antjunit != null) {
                args.add("-DderbyTesting.antjunit=" + antjunit);
            }
            args.add("-Dderby.system.home=system/nested_tMTG");
            args.add("-Dderby.system.durability=" + MissingPermissionsTest.getSystemProperty("derby.system.durability"));
            args.add("-Dderby.tests.trace=" + MissingPermissionsTest.getSystemProperty("derby.tests.trace"));
            args.add("-Dderby.system.debug=" + MissingPermissionsTest.getSystemProperty("derby.tests.debug"));
            String testRunnerClassName = "junit.textui.TestRunner";
            if (JVMInfo.isModuleAware()) {
                args.add("-m");
                args.add("junit/" + testRunnerClassName);
            } else {
                args.add(testRunnerClassName);
            }
            args.add(((Object)((Object)this)).getClass().getName());
            String[] argArray = args.toArray(new String[0]);
            Process p = MissingPermissionsTest.execJavaCmd(argArray);
            SpawnedProcess spawned = new SpawnedProcess(p, "MPT");
            spawned.suppressOutputOnComplete();
            p.getOutputStream().close();
            int exitCode = spawned.complete(120000L);
            MissingPermissionsTest.assertTrue((String)spawned.getFailMessage("subprocess run failed: "), (exitCode == 1 ? 1 : 0) != 0);
            String expectedMessageOnConsole = JVMInfo.isModuleAware() ? "java.security.AccessControlException: access denied (\"java.lang.RuntimePermission\" \"modifyThreadGroup\")" : "WARNING: could not do ThreadGroup#setDaemon on Derby daemons due to a security exception";
            String output = spawned.getFullServerOutput();
            String err = spawned.getFullServerError();
            MissingPermissionsTest.assertTrue((String)("Full error is '" + err + "'"), (boolean)err.contains(expectedMessageOnConsole));
            if (Boolean.parseBoolean(MissingPermissionsTest.getSystemProperty("derby.tests.trace")) || Boolean.parseBoolean(MissingPermissionsTest.getSystemProperty("derby.tests.debug"))) {
                System.out.println("\n[ (subprocess) " + output.replace("\n", "\n  (subprocess) ") + "]\n");
            }
        } else {
            final SystemThreadRun mst = new SystemThreadRun(this);
            Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new Thread(Thread.currentThread().getThreadGroup().getParent(), mst);
                }
            });
            t.start();
            t.join();
            MissingPermissionsTest.assertTrue((boolean)(mst.f instanceof AccessControlException));
            this.openDefaultConnection("APP", "APPPW").close();
        }
    }

    private class SystemThreadRun
    implements Runnable {
        public Throwable f;
        private final BaseJDBCTestCase test;

        public SystemThreadRun(BaseJDBCTestCase test) {
            this.test = test;
        }

        @Override
        public void run() {
            try {
                Assert.assertEquals((String)Thread.currentThread().getThreadGroup().getName(), (String)"system");
                this.test.openDefaultConnection("APP", "APPPW").close();
                Assert.fail();
            }
            catch (Throwable e) {
                this.f = e;
            }
        }
    }
}

