/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.IndexToBaseRowNode;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class FromBaseTable
extends FromTable {
    static final int UNSET = -1;
    private boolean hasCheckedIndexStats;
    TableName tableName;
    TableDescriptor tableDescriptor;
    ConglomerateDescriptor baseConglomerateDescriptor;
    ConglomerateDescriptor[] conglomDescs;
    int updateOrDelete;
    int bulkFetch = -1;
    private String targetTableUUIDString;
    private boolean validatingCheckConstraint = false;
    boolean bulkFetchTurnedOff;
    boolean multiProbing = false;
    private double singleScanRowCount;
    private FormatableBitSet referencedCols;
    private ResultColumnList templateColumns;
    private String[] columnNames;
    private boolean specialMaxScan;
    private boolean distinctScan;
    private boolean raDependentScan;
    private String raParentResultSetId;
    private long fkIndexConglomId;
    private int[] fkColArray;
    PredicateList baseTableRestrictionList;
    PredicateList nonBaseTableRestrictionList;
    PredicateList restrictionList;
    PredicateList storeRestrictionList;
    PredicateList nonStoreRestrictionList;
    PredicateList requalificationRestrictionList;
    static final int UPDATE = 1;
    static final int DELETE = 2;
    private boolean existsBaseTable;
    private boolean isNotExists;
    private JBitSet dependencyMap;
    private boolean getUpdateLocks;
    private boolean authorizeSYSUSERS;
    private String rowLocationColumnName;
    private boolean gotRowCount = false;
    private long rowCount = 0L;

    FromBaseTable(TableName tableName, String correlationName, ResultColumnList derivedRCL, Properties tableProperties, ContextManager cm) {
        super(correlationName, tableProperties, cm);
        this.tableName = tableName;
        this.setResultColumns(derivedRCL);
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.getResultColumns();
    }

    FromBaseTable(TableName tableName, String correlationName, int updateOrDelete, ResultColumnList derivedRCL, ContextManager cm) {
        super(correlationName, null, cm);
        this.tableName = tableName;
        this.updateOrDelete = updateOrDelete;
        this.setResultColumns(derivedRCL);
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.getResultColumns();
    }

    void setRowLocationColumnName(String rowLocationColumnName) {
        this.rowLocationColumnName = rowLocationColumnName;
    }

    @Override
    boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    @Override
    JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        JBitSet map = new JBitSet(numTables);
        this.fillInReferencedTableMap(map);
        return map;
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        ConglomerateDescriptor currentConglomerateDescriptor;
        AccessPath ap;
        block23: {
            block24: {
                block25: {
                    String userSpecifiedIndexName = this.getUserSpecifiedIndexName();
                    ap = this.getCurrentAccessPath();
                    currentConglomerateDescriptor = ap.getConglomerateDescriptor();
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceNextAccessPath(this.getExposedName(), predList == null ? 0 : predList.size());
                    }
                    rowOrdering.removeOptimizable(this.getTableNumber());
                    if (userSpecifiedIndexName != null) {
                        if (currentConglomerateDescriptor != null) {
                            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                                currentConglomerateDescriptor = null;
                            }
                        } else {
                            if (this.optimizerTracingIsOn()) {
                                this.getOptimizerTracer().traceLookingForSpecifiedIndex(userSpecifiedIndexName, this.tableNumber);
                            }
                            if (StringUtil.SQLToUpperCase(userSpecifiedIndexName).equals("NULL")) {
                                currentConglomerateDescriptor = this.tableDescriptor.getConglomerateDescriptor(this.tableDescriptor.getHeapConglomerateId());
                            } else {
                                String conglomerateName;
                                this.getConglomDescs();
                                for (int index = 0; !(index >= this.conglomDescs.length || (conglomerateName = (currentConglomerateDescriptor = this.conglomDescs[index]).getConglomerateName()) != null && conglomerateName.equals(userSpecifiedIndexName)); ++index) {
                                }
                                if (currentConglomerateDescriptor == null) {
                                    SanityManager.THROWASSERT("Expected to find match for forced index " + userSpecifiedIndexName);
                                }
                            }
                            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                                SanityManager.THROWASSERT("No join strategy found");
                            }
                        }
                    } else if (currentConglomerateDescriptor != null) {
                        if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                            currentConglomerateDescriptor = this.getNextConglom(currentConglomerateDescriptor);
                            this.resetJoinStrategies(optimizer);
                            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                                SanityManager.THROWASSERT("No join strategy found");
                            }
                        }
                    } else {
                        currentConglomerateDescriptor = this.getFirstConglom();
                        if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                            SanityManager.THROWASSERT("No join strategy found");
                        }
                    }
                    if (currentConglomerateDescriptor == null) {
                        if (this.optimizerTracingIsOn()) {
                            this.getOptimizerTracer().traceNoMoreConglomerates(this.tableNumber);
                        }
                    } else {
                        currentConglomerateDescriptor.setColumnNames(this.columnNames);
                        if (this.optimizerTracingIsOn()) {
                            this.getOptimizerTracer().traceConsideringConglomerate(currentConglomerateDescriptor, this.tableNumber);
                        }
                    }
                    if (currentConglomerateDescriptor == null) break block23;
                    if (currentConglomerateDescriptor.isIndex()) break block24;
                    if (this.isOneRowResultSet(predList)) break block25;
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceAddingUnorderedOptimizable(predList == null ? 0 : predList.size());
                    }
                    rowOrdering.addUnorderedOptimizable(this);
                    break block23;
                }
                if (!this.optimizerTracingIsOn()) break block23;
                this.getOptimizerTracer().traceScanningHeapWithUniqueKey();
                break block23;
            }
            IndexRowGenerator irg = currentConglomerateDescriptor.getIndexDescriptor();
            int[] baseColumnPositions = irg.baseColumnPositions();
            boolean[] isAscending = irg.isAscending();
            for (int i = 0; i < baseColumnPositions.length; ++i) {
                if (rowOrdering.orderedOnColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i])) continue;
                rowOrdering.nextOrderPosition(isAscending[i] ? 1 : 2);
                rowOrdering.addOrderedColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i]);
            }
        }
        ap.setConglomerateDescriptor(currentConglomerateDescriptor);
        return currentConglomerateDescriptor != null;
    }

    @Override
    protected boolean canBeOrdered() {
        return true;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        optimizer.costOptimizable(this, this.tableDescriptor, this.getCurrentAccessPath().getConglomerateDescriptor(), predList, outerCost);
        return this.getCurrentAccessPath().getCostEstimate();
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        return true;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT(optimizablePredicate instanceof Predicate, "optimizablePredicate expected to be instanceof Predicate");
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
            optimizablePredicates.addOptPredicate(this.restrictionList.getOptPredicate(i));
            this.restrictionList.removeOptPredicate(i);
        }
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        boolean coveringIndex = true;
        if (!cd.isIndex()) {
            return false;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        for (ResultColumn rc : this.getResultColumns()) {
            if (!rc.isReferenced() || rc.getExpression() instanceof ConstantNode) continue;
            coveringIndex = false;
            int colPos = rc.getColumnPosition();
            for (int i = 0; i < baseCols.length; ++i) {
                if (colPos != baseCols[i]) continue;
                coveringIndex = true;
                break;
            }
            if (coveringIndex) continue;
            break;
        }
        return coveringIndex;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        boolean constraintSpecified = false;
        ConstraintDescriptor consDesc = null;
        Enumeration<Object> e = this.tableProperties.keys();
        StringUtil.SQLEqualsIgnoreCase(this.tableDescriptor.getSchemaName(), "SYS");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals("index")) {
                String conglomerateName;
                if (constraintSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                indexSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                ConglomerateDescriptor cd = null;
                ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
                for (int index = 0; !(index >= cds.length || (conglomerateName = (cd = cds[index]).getConglomerateName()) != null && conglomerateName.equals(value)); ++index) {
                    cd = null;
                }
                if (cd == null) {
                    throw StandardException.newException("42Y46", value, this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(cd);
                continue;
            }
            if (key.equals("constraint")) {
                if (indexSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                constraintSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                consDesc = dDictionary.getConstraintDescriptorByName(this.tableDescriptor, null, value, false);
                if (consDesc == null || !consDesc.hasBackingIndex()) {
                    throw StandardException.newException("42Y48", value, this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(consDesc);
                continue;
            }
            if (key.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(value);
                continue;
            }
            if (key.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.parseFloat(value);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", value, key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (key.equals("bulkFetch")) {
                this.bulkFetch = this.getIntProperty(value, key);
                if (this.bulkFetch <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(this.bulkFetch));
                }
                if (!this.forUpdate()) continue;
                throw StandardException.newException("42Y66", new Object[0]);
            }
            if (key.equals("validateCheckConstraint")) continue;
            throw StandardException.newException("42Y44", key, "index, constraint, joinStrategy");
        }
        if (constraintSpecified && consDesc != null) {
            ConglomerateDescriptor cd = dDictionary.getConglomerateDescriptor(consDesc.getConglomerateId());
            String indexName = cd.getConglomerateName();
            this.tableProperties.remove("constraint");
            this.tableProperties.put("index", indexName);
        }
    }

    private boolean isValidatingCheckConstraint() throws StandardException {
        if (this.tableProperties == null) {
            return false;
        }
        Enumeration<Object> e = this.tableProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (!key.equals("validateCheckConstraint")) continue;
            this.targetTableUUIDString = value;
            this.validatingCheckConstraint = true;
            return true;
        }
        return false;
    }

    @Override
    public String getBaseTableName() {
        return this.tableName.getTableName();
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        AccessPath ap = this.getCurrentAccessPath();
        AccessPath bestAp = this.getBestAccessPath();
        AccessPath bestSortAp = this.getBestSortAvoidancePath();
        ap.setConglomerateDescriptor(null);
        bestAp.setConglomerateDescriptor(null);
        bestSortAp.setConglomerateDescriptor(null);
        ap.setCoveringIndexScan(false);
        bestAp.setCoveringIndexScan(false);
        bestSortAp.setCoveringIndexScan(false);
        ap.setLockMode(0);
        bestAp.setLockMode(0);
        bestSortAp.setLockMode(0);
        CostEstimate costEst = this.getCostEstimate(optimizer);
        ap.setCostEstimate(costEst);
        costEst.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        super.startOptimizing(optimizer, rowOrdering);
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition) {
        return this.mapAbsoluteToRelativeColumnPosition(absolutePosition);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        boolean statisticsForTable = false;
        boolean statisticsForConglomerate = false;
        PredicateList unknownPredicateList = null;
        if (optimizer.useStatistics() && predList != null) {
            statisticsForConglomerate = this.tableDescriptor.statisticsExist(cd);
            statisticsForTable = this.tableDescriptor.statisticsExist(null);
            unknownPredicateList = new PredicateList(this.getContextManager());
            predList.copyPredicatesToOtherList(unknownPredicateList);
            if (!this.hasCheckedIndexStats) {
                this.hasCheckedIndexStats = true;
                if (this.qualifiesForStatisticsUpdateCheck(this.tableDescriptor)) {
                    this.tableDescriptor.markForIndexStatsUpdate(this.baseRowCount());
                }
            }
        }
        AccessPath currAccessPath = this.getCurrentAccessPath();
        JoinStrategy currentJoinStrategy = currAccessPath.getJoinStrategy();
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceEstimatingCostOfConglomerate(cd, this.tableNumber);
        }
        double tableUniquenessFactor = optimizer.uniqueJoinWithOuterTable(predList);
        boolean oneRowResultSetForSomeConglom = this.isOneRowResultSet(predList);
        this.baseTableRestrictionList.removeAllElements();
        currentJoinStrategy.getBasePredicates(predList, this.baseTableRestrictionList, this);
        StoreCostController scc = this.getStoreCostController(cd);
        CostEstimate costEst = this.getScratchCostEstimate(optimizer);
        if (this.isOneRowResultSet(cd, this.baseTableRestrictionList)) {
            OptimizablePredicate pred;
            rowOrdering.optimizableAlwaysOrdered(this);
            this.singleScanRowCount = 1.0;
            double cost = scc.getFetchFromFullKeyCost(null, 0);
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceSingleMatchedRowCost(cost, this.tableNumber);
            }
            costEst.setCost(cost, 1.0, 1.0);
            double newCost = costEst.getEstimatedCost();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            costEst.setCost(newCost, costEst.rowCount() * outerCost.rowCount(), costEst.singleScanRowCount());
            boolean constantStartStop = true;
            for (int i = 0; i < predList.size() && ((pred = predList.getOptPredicate(i)).isStartKey() || pred.isStopKey()); ++i) {
                if (pred.getReferencedMap().hasSingleBitSet()) continue;
                constantStartStop = false;
                break;
            }
            if (constantStartStop) {
                currAccessPath.setLockMode(6);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceConstantStartStopPositions();
                }
            } else {
                this.setLockingBasedOnThreshold(optimizer, costEst.rowCount());
            }
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfNScans(this.tableNumber, outerCost.rowCount(), costEst);
            }
            if (cd.isIndex() && !this.isCoveringIndex(cd)) {
                double singleFetchCost = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                cost = singleFetchCost * costEst.rowCount();
                costEst.setEstimatedCost(costEst.getEstimatedCost() + cost);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceNonCoveringIndexCost(cost, this.tableNumber);
                }
            }
        } else {
            double maxRows;
            double maxRows2;
            double scanUniquenessFactor;
            int stopOperator;
            int startOperator;
            OptimizablePredicate pred;
            double extraFirstColumnSelectivity = 1.0;
            double extraStartStopSelectivity = 1.0;
            double extraQualifierSelectivity = 1.0;
            double extraNonQualifierSelectivity = 1.0;
            double statStartStopSelectivity = 1.0;
            double statCompositeSelectivity = 1.0;
            int numExtraFirstColumnPreds = 0;
            int numExtraStartStopPreds = 0;
            int numExtraQualifiers = 0;
            int numExtraNonQualifiers = 0;
            boolean startGap = false;
            boolean stopGap = false;
            boolean seenFirstColumn = false;
            boolean constantStartStop = true;
            boolean startStopFound = false;
            int startKeyNum = 0;
            int stopKeyNum = 0;
            int predListSize = predList != null ? this.baseTableRestrictionList.size() : 0;
            int startStopPredCount = 0;
            ColumnReference firstColumn = null;
            for (int i = 0; i < predListSize; ++i) {
                pred = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred.isStartKey();
                boolean stopKey = pred.isStopKey();
                if (startKey || stopKey) {
                    startStopFound = true;
                    if (!pred.getReferencedMap().hasSingleBitSet()) {
                        constantStartStop = false;
                    }
                    boolean knownConstant = pred.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            ++startKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred);
                            }
                        } else {
                            startGap = true;
                        }
                    }
                    if (stopKey) {
                        if (knownConstant && !stopGap) {
                            ++stopKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred);
                            }
                        } else {
                            stopGap = true;
                        }
                    }
                    if (!startGap && !stopGap || this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                    if (startKey && stopKey) {
                        ++startStopPredCount;
                    }
                    if (pred.getIndexPosition() == 0) {
                        extraFirstColumnSelectivity *= pred.selectivity(this);
                        if (seenFirstColumn) continue;
                        ValueNode relNode = ((Predicate)pred).getAndNode().getLeftOperand();
                        if (relNode instanceof BinaryRelationalOperatorNode) {
                            firstColumn = ((BinaryRelationalOperatorNode)relNode).getColumnOperand(this);
                        }
                        seenFirstColumn = true;
                        continue;
                    }
                    extraStartStopSelectivity *= pred.selectivity(this);
                    ++numExtraStartStopPreds;
                    continue;
                }
                if (this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                if (pred instanceof Predicate) {
                    ColumnReference cr;
                    ValueNode receiver;
                    LikeEscapeOperatorNode likeNode;
                    ValueNode leftOpnd = ((Predicate)pred).getAndNode().getLeftOperand();
                    if (firstColumn != null && leftOpnd instanceof LikeEscapeOperatorNode && (likeNode = (LikeEscapeOperatorNode)leftOpnd).getLeftOperand().requiresTypeFromContext() && (receiver = likeNode.getReceiver()) instanceof ColumnReference && (cr = (ColumnReference)receiver).getTableNumber() == firstColumn.getTableNumber() && cr.getColumnNumber() == firstColumn.getColumnNumber()) {
                        extraFirstColumnSelectivity *= 0.2;
                    }
                }
                if (pred.isQualifier()) {
                    extraQualifierSelectivity *= pred.selectivity(this);
                    ++numExtraQualifiers;
                } else {
                    extraNonQualifierSelectivity *= pred.selectivity(this);
                    ++numExtraNonQualifiers;
                }
                startGap = true;
                stopGap = true;
            }
            if (unknownPredicateList != null && (statCompositeSelectivity = unknownPredicateList.selectivity(this)) == -1.0) {
                statCompositeSelectivity = 1.0;
            }
            if (seenFirstColumn && startStopPredCount > 0) {
                IndexRowGenerator irg;
                if (statisticsForConglomerate) {
                    statStartStopSelectivity = this.tableDescriptor.selectivityForConglomerate(cd, startStopPredCount);
                } else if (cd.isIndex() && (irg = cd.getIndexDescriptor()).isUnique() && irg.numberOfOrderedColumns() == 1 && startStopPredCount == 1) {
                    statStartStopSelectivity = 1.0 / (double)this.baseRowCount();
                }
            }
            extraNonQualifierSelectivity *= currentJoinStrategy.nonBasePredicateSelectivity(this, predList);
            DataValueDescriptor[] startKeys = startKeyNum > 0 ? new DataValueDescriptor[startKeyNum] : null;
            DataValueDescriptor[] stopKeys = stopKeyNum > 0 ? new DataValueDescriptor[stopKeyNum] : null;
            startKeyNum = 0;
            stopKeyNum = 0;
            startGap = false;
            stopGap = false;
            InListOperatorNode ssKeySourceInList = null;
            for (int i = 0; i < predListSize; ++i) {
                pred = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred.isStartKey();
                boolean stopKey = pred.isStopKey();
                if (startKey || stopKey) {
                    if (ssKeySourceInList != null && ((Predicate)pred).isInListProbePredicate()) {
                        SanityManager.THROWASSERT("Found multiple probe predicate start/stop keys for conglomerate '" + cd.getConglomerateName() + "' when at most one was expected.");
                    }
                    ssKeySourceInList = ((Predicate)pred).getSourceInList(true);
                    boolean knownConstant = pred.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            startKeys[startKeyNum] = pred.getCompareValue(this);
                            ++startKeyNum;
                        } else {
                            startGap = true;
                        }
                    }
                    if (!stopKey) continue;
                    if (knownConstant && !stopGap) {
                        stopKeys[stopKeyNum] = pred.getCompareValue(this);
                        ++stopKeyNum;
                        continue;
                    }
                    stopGap = true;
                    continue;
                }
                startGap = true;
                stopGap = true;
            }
            if (this.baseTableRestrictionList != null) {
                startOperator = this.baseTableRestrictionList.startOperator(this);
                stopOperator = this.baseTableRestrictionList.stopOperator(this);
            } else {
                startOperator = 0;
                stopOperator = 0;
            }
            DataValueDescriptor[] rowTemplate = this.getRowTemplate(cd, this.getBaseCostController());
            long baseRC = startKeys != null || stopKeys != null ? this.baseRowCount() : this.baseRowCount() + 5L;
            scc.getScanCost(currentJoinStrategy.scanCostType(), baseRC, 1, this.forUpdate(), null, rowTemplate, startKeys, startOperator, stopKeys, stopOperator, false, 0, costEst);
            double initialPositionCost = 0.0;
            if (cd.isIndex()) {
                initialPositionCost = scc.getFetchFromFullKeyCost(null, 0);
                if (oneRowResultSetForSomeConglom && costEst.rowCount() <= 1.0) {
                    costEst.setCost(costEst.getEstimatedCost() * 2.0, costEst.rowCount() + 2.0, costEst.singleScanRowCount() + 2.0);
                }
            }
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfConglomerateScan(this.tableNumber, cd, costEst, numExtraFirstColumnPreds, extraFirstColumnSelectivity, numExtraStartStopPreds, extraStartStopSelectivity, startStopPredCount, statStartStopSelectivity, numExtraQualifiers, extraQualifierSelectivity, numExtraNonQualifiers, extraNonQualifierSelectivity);
            }
            double initialRowCount = costEst.rowCount();
            if (statStartStopSelectivity != 1.0) {
                costEst.setCost(this.scanCostAfterSelectivity(costEst.getEstimatedCost(), initialPositionCost, statStartStopSelectivity, oneRowResultSetForSomeConglom), costEst.rowCount() * statStartStopSelectivity, costEst.singleScanRowCount() * statStartStopSelectivity);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingStatsForIndex(costEst, this.tableNumber);
                }
            } else {
                if (extraFirstColumnSelectivity != 1.0) {
                    costEst.setCost(this.scanCostAfterSelectivity(costEst.getEstimatedCost(), initialPositionCost, extraFirstColumnSelectivity, oneRowResultSetForSomeConglom), costEst.rowCount() * extraFirstColumnSelectivity, costEst.singleScanRowCount() * extraFirstColumnSelectivity);
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingExtra1stColumnSelectivity(costEst, this.tableNumber);
                    }
                }
                if (extraStartStopSelectivity != 1.0) {
                    costEst.setCost(costEst.getEstimatedCost(), costEst.rowCount() * extraStartStopSelectivity, costEst.singleScanRowCount() * extraStartStopSelectivity);
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingExtraStartStop(costEst, this.tableNumber);
                    }
                }
            }
            if (ssKeySourceInList != null) {
                int listSize = ssKeySourceInList.getRightOperandList().size();
                double rc = costEst.rowCount() * (double)listSize;
                double ssrc = costEst.singleScanRowCount() * (double)listSize;
                costEst.setCost(costEst.getEstimatedCost() * (double)listSize, rc > initialRowCount ? initialRowCount : rc, ssrc > initialRowCount ? initialRowCount : ssrc);
            }
            if (!startStopFound) {
                currAccessPath.setLockMode(7);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceNoStartStopPosition();
                }
            } else {
                double rowsTouched = costEst.rowCount();
                if (!constantStartStop && currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                    double r = this.baseRowCount();
                    if (r > 0.0) {
                        double rowsTouchedAllScans;
                        double s = costEst.rowCount();
                        double o = outerCost.rowCount();
                        double pRowsNotTouchedPerScan = 1.0 - s / r;
                        double pRowsNotTouchedAllScans = Math.pow(pRowsNotTouchedPerScan, o);
                        double pRowsTouchedAllScans = 1.0 - pRowsNotTouchedAllScans;
                        rowsTouched = rowsTouchedAllScans = r * pRowsTouchedAllScans;
                    } else {
                        rowsTouched = optimizer.tableLockThreshold() + 1;
                    }
                }
                this.setLockingBasedOnThreshold(optimizer, rowsTouched);
            }
            if (cd.isIndex() && !this.isCoveringIndex(cd)) {
                double singleFetchCost = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                double rowsToFetch = costEst.rowCount();
                if (oneRowResultSetForSomeConglom) {
                    rowsToFetch = Math.max(1.0, rowsToFetch);
                }
                double cost = singleFetchCost * rowsToFetch;
                costEst.setEstimatedCost(costEst.getEstimatedCost() + cost);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostOfNoncoveringIndex(costEst, this.tableNumber);
                }
            }
            if (extraQualifierSelectivity != 1.0) {
                costEst.setCost(costEst.getEstimatedCost(), costEst.rowCount() * extraQualifierSelectivity, costEst.singleScanRowCount() * extraQualifierSelectivity);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingExtraQualifierSelectivity(costEst, this.tableNumber);
                }
            }
            this.singleScanRowCount = costEst.singleScanRowCount();
            double newCost = costEst.getEstimatedCost();
            double rowCnt = costEst.rowCount();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            rowCnt *= outerCost.rowCount();
            initialRowCount *= outerCost.rowCount();
            if (oneRowResultSetForSomeConglom && outerCost.rowCount() < rowCnt) {
                rowCnt = outerCost.rowCount();
            }
            if (cd.isIndex() && startStopFound && !constantStartStop && (scanUniquenessFactor = optimizer.uniqueJoinWithOuterTable(this.baseTableRestrictionList)) > 0.0 && rowCnt > (maxRows2 = (double)this.baseRowCount() / scanUniquenessFactor)) {
                newCost *= maxRows2 / rowCnt;
            }
            if (tableUniquenessFactor > 0.0 && rowCnt > (maxRows = (double)this.baseRowCount() / tableUniquenessFactor)) {
                rowCnt = maxRows;
            }
            costEst.setCost(newCost, rowCnt, costEst.singleScanRowCount());
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceCostOfNScans(this.tableNumber, outerCost.rowCount(), costEst);
            }
            double rc = -1.0;
            double src = -1.0;
            if (this.existsBaseTable) {
                src = 1.0;
                rc = 1.0;
            } else if (extraNonQualifierSelectivity != 1.0) {
                rc = oneRowResultSetForSomeConglom ? costEst.rowCount() : costEst.rowCount() * extraNonQualifierSelectivity;
                src = costEst.singleScanRowCount() * extraNonQualifierSelectivity;
            }
            if (rc != -1.0) {
                costEst.setCost(costEst.getEstimatedCost(), rc, src);
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCostIncludingExtraNonQualifierSelectivity(costEst, this.tableNumber);
                }
            }
            if (statisticsForTable && !oneRowResultSetForSomeConglom && statCompositeSelectivity != 1.0) {
                double compositeStatRC = initialRowCount * statCompositeSelectivity;
                if (this.optimizerTracingIsOn()) {
                    this.getOptimizerTracer().traceCompositeSelectivityFromStatistics(statCompositeSelectivity);
                }
                if (!(tableUniquenessFactor > 0.0) || !(compositeStatRC > (double)this.baseRowCount() * tableUniquenessFactor)) {
                    costEst.setCost(costEst.getEstimatedCost(), compositeStatRC, this.existsBaseTable ? 1.0 : compositeStatRC / outerCost.rowCount());
                    if (this.optimizerTracingIsOn()) {
                        this.getOptimizerTracer().traceCostIncludingCompositeSelectivityFromStats(costEst, this.tableNumber);
                    }
                }
            }
        }
        currentJoinStrategy.putBasePredicates(predList, this.baseTableRestrictionList);
        return costEst;
    }

    private double scanCostAfterSelectivity(double originalScanCost, double initialPositionCost, double selectivity, boolean anotherIndexUnique) throws StandardException {
        double afterInitialCost;
        double minSelectivity;
        double r;
        if (anotherIndexUnique && (r = (double)this.baseRowCount()) > 0.0 && (minSelectivity = 2.0 / r) > selectivity) {
            selectivity = minSelectivity;
        }
        if ((afterInitialCost = (originalScanCost - initialPositionCost) * selectivity) < 0.0) {
            afterInitialCost = 0.0;
        }
        return initialPositionCost + afterInitialCost;
    }

    private void setLockingBasedOnThreshold(Optimizer optimizer, double rowsTouched) {
        this.getCurrentAccessPath().setLockMode(6);
    }

    @Override
    public boolean isBaseTable() {
        return true;
    }

    @Override
    public boolean forUpdate() {
        return this.updateOrDelete != 0 || this.isCursorTargetTable() || this.getUpdateLocks;
    }

    @Override
    public int initialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        return super.memoryUsageOK(this.singleScanRowCount, maxMemoryPerTable);
    }

    @Override
    public boolean isTargetTable() {
        return this.updateOrDelete != 0;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        double retval = -1.0;
        PredicateList pl = (PredicateList)predList;
        int numColumns = this.getTableDescriptor().getNumberOfColumns();
        int tableNo = this.getTableNumber();
        int[] tableNumbers = new int[]{};
        JBitSet[] tableColMap = new JBitSet[]{new JBitSet(numColumns + 1)};
        pl.checkTopPredicatesForEqualsConditions(tableNo, null, tableNumbers, tableColMap, false);
        if (this.supersetOfUniqueIndex(tableColMap)) {
            retval = this.getBestAccessPath().getCostEstimate().singleScanRowCount();
        }
        return retval;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        if (this.existsBaseTable) {
            return false;
        }
        return super.isOneRowScan();
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        if (this.existsBaseTable) {
            return assignedTableMap.contains(this.dependencyMap);
        }
        return true;
    }

    @Override
    public String toString() {
        return "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\ntableDescriptor: " + this.tableDescriptor + "\nupdateOrDelete: " + this.updateOrDelete + "\n" + (this.tableProperties != null ? this.tableProperties.toString() : "null") + "\nexistsBaseTable: " + this.existsBaseTable + "\ndependencyMap: " + (this.dependencyMap != null ? this.dependencyMap.toString() : "null") + "\n" + super.toString();
    }

    boolean getExistsBaseTable() {
        return this.existsBaseTable;
    }

    void setExistsBaseTable(boolean existsBaseTable, JBitSet dependencyMap, boolean isNotExists) {
        this.existsBaseTable = existsBaseTable;
        this.isNotExists = isNotExists;
        this.dependencyMap = existsBaseTable ? dependencyMap : null;
    }

    void clearDependency(List<Integer> locations) {
        if (this.dependencyMap != null) {
            for (int i = 0; i < locations.size(); ++i) {
                this.dependencyMap.clear(locations.get(i));
            }
        }
    }

    void setTableProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        String currentUser;
        String databaseOwner;
        this.tableName.bind();
        TableDescriptor tabDescr = this.bindTableDescriptor();
        if (tabDescr.getTableType() == 5) {
            ResultSetNode vtiNode = this.mapTableAsVTI(tabDescr, this.getCorrelationName(), this.getResultColumns(), this.getProperties(), this.getContextManager());
            return vtiNode.bindNonVTITables(dataDictionary, fromListParam);
        }
        ResultColumnList derivedRCL = this.getResultColumns();
        this.restrictionList = new PredicateList(this.getContextManager());
        this.baseTableRestrictionList = new PredicateList(this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        this.setResultColumns(this.genResultColList());
        this.templateColumns = this.getResultColumns();
        if (tabDescr.getTableType() == 2) {
            ViewDescriptor vd = dataDictionary.getViewDescriptor(tabDescr);
            SchemaDescriptor compSchema = dataDictionary.getSchemaDescriptor(vd.getCompSchemaId(), null);
            compilerContext.pushCompilationSchema(compSchema);
            try {
                compilerContext.createDependency(vd);
                CreateViewNode cvn = (CreateViewNode)this.parseStatement(vd.getViewText(), false);
                ResultSetNode rsn = cvn.getParsedQueryExpression();
                if (rsn.getResultColumns().containsAllResultColumn()) {
                    this.getResultColumns().setCountMismatchAllowed(true);
                }
                for (Object rc : this.getResultColumns()) {
                    if (!this.isPrivilegeCollectionRequired()) continue;
                    compilerContext.addRequiredColumnPriv(((ResultColumn)rc).getTableColumnDescriptor());
                }
                FromSubquery fsq = new FromSubquery(rsn, cvn.getOrderByList(), cvn.getOffset(), cvn.getFetchFirst(), cvn.hasJDBClimitClause(), this.correlationName != null ? this.correlationName : this.getOrigTableName().getTableName(), this.getResultColumns(), this.tableProperties, this.getContextManager());
                fsq.setLevel(this.level);
                CollectNodesVisitor<QueryTreeNode> cnv = new CollectNodesVisitor<QueryTreeNode>(QueryTreeNode.class);
                fsq.accept(cnv);
                for (QueryTreeNode node : cnv.getList()) {
                    node.disablePrivilegeCollection();
                }
                fsq.setOrigTableName(this.getOrigTableName());
                fsq.setOrigCompilationSchema(compSchema);
                ResultSetNode fsqBound = fsq.bindNonVTITables(dataDictionary, fromListParam);
                if (derivedRCL != null) {
                    fsqBound.getResultColumns().propagateDCLInfo(derivedRCL, this.origTableName.getFullTableName());
                }
                ResultSetNode resultSetNode = fsqBound;
                return resultSetNode;
            }
            finally {
                compilerContext.popCompilationSchema();
            }
        }
        compilerContext.createDependency(tabDescr);
        this.baseConglomerateDescriptor = tabDescr.getConglomerateDescriptor(tabDescr.getHeapConglomerateId());
        if (this.baseConglomerateDescriptor == null) {
            throw StandardException.newException("XSAI2.S", tabDescr.getHeapConglomerateId());
        }
        this.columnNames = this.getResultColumns().getColumnNames();
        if (derivedRCL != null) {
            this.getResultColumns().propagateDCLInfo(derivedRCL, this.origTableName.getFullTableName());
        }
        if (this.tableNumber == -1) {
            this.tableNumber = compilerContext.getNextTableNumber();
        }
        boolean bl = this.authorizeSYSUSERS = dataDictionary.usesSqlAuthorization() && tabDescr.getUUID().toString().equals("9810800c-0134-14a5-40c1-000004f61f90");
        if (this.authorizeSYSUSERS && !(databaseOwner = dataDictionary.getAuthorizationDatabaseOwner()).equals(currentUser = this.getLanguageConnectionContext().getStatementContext().getSQLSessionContext().getCurrentUser())) {
            throw StandardException.newException("4251D", new Object[0]);
        }
        return this;
    }

    private ResultSetNode mapTableAsVTI(TableDescriptor td, String correlationName, ResultColumnList resultColumns, Properties tableProperties, ContextManager cm) throws StandardException {
        FromVTI vtiNode;
        List<ValueNode> emptyList = Collections.emptyList();
        NewInvocationNode newNode = new NewInvocationNode(null, td, emptyList, false, cm);
        if (correlationName != null) {
            vtiNode = new FromVTI(newNode, correlationName, resultColumns, tableProperties, cm);
        } else {
            TableName exposedName = newNode.makeTableName(td.getSchemaName(), td.getDescriptorName());
            vtiNode = new FromVTI(newNode, null, resultColumns, tableProperties, exposedName, cm);
        }
        return vtiNode;
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        String fullName;
        String ourSchemaName = this.getOrigTableName().getSchemaName();
        String string = fullName = schemaName != null ? schemaName + "." + name : name;
        if (exactMatch) {
            if (schemaName != null && ourSchemaName == null || schemaName == null && ourSchemaName != null) {
                return null;
            }
            if (this.getExposedName().equals(fullName)) {
                return this;
            }
            return null;
        }
        if (this.getExposedName().equals(fullName)) {
            return this;
        }
        if (schemaName != null && ourSchemaName != null || schemaName == null && ourSchemaName == null) {
            return null;
        }
        if (schemaName != null && ourSchemaName == null) {
            if (this.tableName.equals(this.origTableName) && !schemaName.equals(this.tableDescriptor.getSchemaDescriptor().getSchemaName())) {
                return null;
            }
            if (!this.getExposedName().equals(name)) {
                return null;
            }
            if (!this.getExposedName().equals(this.getOrigTableName().getTableName())) {
                return null;
            }
            return this;
        }
        if (!this.getExposedName().equals(this.getOrigTableName().getSchemaName() + "." + name)) {
            return null;
        }
        return this;
    }

    private TableDescriptor bindTableDescriptor() throws StandardException {
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        this.tableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.tableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.tableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.tableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        return this.tableDescriptor;
    }

    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
    }

    @Override
    void bindResultColumns(FromList fromListParam) throws StandardException {
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        TableName exposedTableName;
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getQualifiedTableName();
        if (columnsTableName != null && columnsTableName.getSchemaName() == null && this.correlationName == null) {
            columnsTableName.bind();
        }
        if ((exposedTableName = this.getExposedTableName()).getSchemaName() == null && this.correlationName == null) {
            exposedTableName.bind();
        }
        if (columnsTableName == null || columnsTableName.equals(exposedTableName)) {
            if (this.getResultColumns() == null) {
                throw StandardException.newException("42ZB7", columnReference.getColumnName());
            }
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
            if (resultColumn != null) {
                columnReference.setTableNumber(this.tableNumber);
                columnReference.setColumnNumber(resultColumn.getColumnPosition());
                if (!(this.tableDescriptor == null || this.rowLocationColumnName != null && this.rowLocationColumnName.equals(columnReference.getColumnName()))) {
                    FormatableBitSet referencedColumnMap;
                    if (columnReference.isPrivilegeCollectionRequired() && columnReference.taggedWith("updatePrivs")) {
                        this.getCompilerContext().addRequiredColumnPriv(this.tableDescriptor.getColumnDescriptor(columnReference.getColumnName()));
                    }
                    if ((referencedColumnMap = this.tableDescriptor.getReferencedColumnMap()) == null) {
                        referencedColumnMap = new FormatableBitSet(this.tableDescriptor.getNumberOfColumns() + 1);
                    }
                    referencedColumnMap.set(resultColumn.getColumnPosition());
                    this.tableDescriptor.setReferencedColumnMap(referencedColumnMap);
                }
            }
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        if (this.authorizeSYSUSERS) {
            int passwordColNum = 3;
            FormatableBitSet refCols = this.getResultColumns().getReferencedFormatableBitSet(false, true, false);
            if (refCols.getLength() >= passwordColNum && refCols.isSet(passwordColNum - 1)) {
                throw StandardException.newException("4251E", "SYSUSERS", "PASSWORD");
            }
        }
        this.setReferencedTableMap(new JBitSet(numTables));
        this.getReferencedTableMap().set(this.tableNumber);
        return this.genProjectRestrict(numTables);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        prRCList.genVirtualColumnNodes(this, this.getResultColumns(), false);
        prRCList.doProjection();
        ProjectRestrictNode result = new ProjectRestrictNode(this, prRCList, null, null, null, null, null, this.getContextManager());
        if (this.isValidatingCheckConstraint()) {
            CompilerContext cc = this.getCompilerContext();
            if ((cc.getReliability() & 0x400) != 0) {
                throw StandardException.newException("42X01", "validateCheckConstraint");
            }
            result.setValidatingCheckConstraints(this.targetTableUUIDString);
        }
        return result;
    }

    @Override
    ResultSetNode changeAccessPath() throws StandardException {
        FormatableBitSet heapReferencedCols;
        AccessPath ap = this.getTrulyTheBestAccessPath();
        ConglomerateDescriptor trulyTheBestConglomerateDescriptor = ap.getConglomerateDescriptor();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        Optimizer opt = ap.getOptimizer();
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceChangingAccessPathForTable(this.tableNumber);
        }
        SanityManager.ASSERT(trulyTheBestConglomerateDescriptor != null, "Should only modify access path after conglomerate has been chosen.");
        if (this.bulkFetch != -1) {
            if (!trulyTheBestJoinStrategy.bulkFetchOK()) {
                throw StandardException.newException("42Y65", trulyTheBestJoinStrategy.getName());
            }
            if (trulyTheBestJoinStrategy.ignoreBulkFetch()) {
                this.disableBulkFetch();
            } else if (this.isOneRowResultSet()) {
                this.disableBulkFetch();
            }
        }
        if (this.bulkFetch == 1) {
            this.disableBulkFetch();
        }
        this.restrictionList.removeRedundantPredicates();
        this.storeRestrictionList = new PredicateList(this.getContextManager());
        this.nonStoreRestrictionList = new PredicateList(this.getContextManager());
        this.requalificationRestrictionList = new PredicateList(this.getContextManager());
        trulyTheBestJoinStrategy.divideUpPredicateLists(this, this.restrictionList, this.storeRestrictionList, this.nonStoreRestrictionList, this.requalificationRestrictionList, this.getDataDictionary());
        for (Predicate pred : this.restrictionList) {
            if (!pred.isInListProbePredicate() || !pred.isStartKey()) continue;
            this.disableBulkFetch();
            this.multiProbing = true;
            break;
        }
        if (!(!trulyTheBestJoinStrategy.bulkFetchOK() || trulyTheBestJoinStrategy.ignoreBulkFetch() || this.bulkFetchTurnedOff || this.bulkFetch != -1 || this.forUpdate() || this.isOneRowResultSet() || this.getLevel() != 0 || this.validatingCheckConstraint)) {
            this.bulkFetch = this.getDefaultBulkFetch();
        }
        this.getCompilerContext().createDependency(trulyTheBestConglomerateDescriptor);
        if (!trulyTheBestConglomerateDescriptor.isIndex()) {
            boolean isSysstatements = this.tableName.equals("SYS", "SYSSTATEMENTS");
            this.templateColumns = this.getResultColumns();
            this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), isSysstatements, false);
            this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), isSysstatements));
            return this;
        }
        if (ap.getCoveringIndexScan() && !this.isCursorTargetTable()) {
            this.setResultColumns(this.newResultColumns(this.getResultColumns(), trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false));
            this.templateColumns = this.newResultColumns(this.getResultColumns(), trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns.addRCForRID();
            if (this.forUpdate()) {
                this.getResultColumns().addRCForRID();
            }
            this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
            this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), true));
            this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
            return this;
        }
        this.getCompilerContext().createDependency(this.baseConglomerateDescriptor);
        if (this.bulkFetch != -1) {
            this.restrictionList.copyPredicatesToOtherList(this.requalificationRestrictionList);
        }
        ResultColumnList newResultColumns = this.newResultColumns(this.getResultColumns(), trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, true);
        FormatableBitSet indexReferencedCols = null;
        if (this.bulkFetch == -1 && (this.requalificationRestrictionList == null || this.requalificationRestrictionList.size() == 0)) {
            indexReferencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
            heapReferencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, true);
            if (heapReferencedCols != null) {
                indexReferencedCols.xor(heapReferencedCols);
            }
        } else {
            heapReferencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), true, false);
        }
        ResultColumnList heapRCL = this.getResultColumns().compactColumns(this.isCursorTargetTable(), false);
        heapRCL.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        IndexToBaseRowNode retval = new IndexToBaseRowNode(this, this.baseConglomerateDescriptor, heapRCL, this.isCursorTargetTable(), heapReferencedCols, indexReferencedCols, this.requalificationRestrictionList, this.forUpdate(), this.tableProperties, this.getContextManager());
        this.setResultColumns(newResultColumns);
        this.templateColumns = this.newResultColumns(this.getResultColumns(), trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
        if (this.bulkFetch != -1) {
            this.getResultColumns().markAllUnreferenced();
            this.storeRestrictionList.markReferencedColumns();
            if (this.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList.markReferencedColumns();
            }
        }
        this.getResultColumns().addRCForRID();
        this.templateColumns.addRCForRID();
        this.referencedCols = this.getResultColumns().getReferencedFormatableBitSet(this.isCursorTargetTable(), false, false);
        this.setResultColumns(this.getResultColumns().compactColumns(this.isCursorTargetTable(), false));
        this.getResultColumns().setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        this.getUpdateLocks = this.isCursorTargetTable();
        this.setCursorTargetTable(false);
        return retval;
    }

    private ResultColumnList newResultColumns(ResultColumnList oldColumns, ConglomerateDescriptor idxCD, ConglomerateDescriptor heapCD, boolean cloneRCs) throws StandardException {
        IndexRowGenerator irg = idxCD.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        ResultColumnList newCols = new ResultColumnList(this.getContextManager());
        for (int i = 0; i < baseCols.length; ++i) {
            ResultColumn newCol;
            int basePosition = baseCols[i];
            ResultColumn oldCol = oldColumns.getResultColumn(basePosition);
            SanityManager.ASSERT(oldCol != null, "Couldn't find base column " + basePosition + "\n.  RCL is\n" + oldColumns);
            if (cloneRCs) {
                newCol = oldCol.cloneMe();
                oldCol.setExpression(new VirtualColumnNode(this, newCol, oldCol.getVirtualColumnId(), this.getContextManager()));
            } else {
                newCol = oldCol;
            }
            newCols.addResultColumn(newCol);
        }
        newCols.setIndexRow(heapCD.getConglomerateNumber(), this.forUpdate());
        return newCols;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.rowLocationColumnName != null) {
            this.getResultColumns().conglomerateId = this.tableDescriptor.getHeapConglomerateId();
        }
        this.generateResultSet(acb, mb);
        if (this.isCursorTargetTable()) {
            acb.rememberCursorTarget(mb);
        }
    }

    @Override
    void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getTrulyTheBestAccessPath().getConglomerateDescriptor() != null);
        this.assignResultSetNumber();
        if (this.specialMaxScan) {
            this.generateMaxSpecialResultSet(acb, mb);
            return;
        }
        if (this.distinctScan) {
            this.generateDistinctScan(acb, mb);
            return;
        }
        if (this.raDependentScan) {
            this.generateRefActionDependentTableScan(acb, mb);
            return;
        }
        JoinStrategy trulyTheBestJoinStrategy = this.getTrulyTheBestAccessPath().getJoinStrategy();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.callMethod((short)185, null, trulyTheBestJoinStrategy.resultSetMethodName(this.bulkFetch != -1, this.multiProbing, this.validatingCheckConstraint), "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    @Override
    CostEstimate getFinalCostEstimate() {
        return this.getTrulyTheBestAccessPath().getCostEstimate();
    }

    private void pushIndexName(ConglomerateDescriptor cd, MethodBuilder mb) throws StandardException {
        if (cd.isConstraint()) {
            DataDictionary dd = this.getDataDictionary();
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(this.tableDescriptor, cd.getUUID());
            mb.push(constraintDesc.getConstraintName());
        } else if (cd.isIndex()) {
            mb.push(cd.getConglomerateName());
        } else {
            mb.pushNull("java.lang.String");
        }
    }

    private void generateMaxSpecialResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEst = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false)));
        mb.push(cd.getConglomerateNumber());
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEst.singleScanRowCount());
        mb.push(costEst.getEstimatedCost());
        mb.callMethod((short)185, null, "getLastIndexKeyResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    private void generateDistinctScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int index;
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEst = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        int[] hashKeyCols = new int[this.getResultColumns().size()];
        if (this.referencedCols == null) {
            for (index = 0; index < hashKeyCols.length; ++index) {
                hashKeyCols[index] = index;
            }
        } else {
            index = 0;
            int colNum = this.referencedCols.anySetBit();
            while (colNum != -1) {
                hashKeyCols[index++] = colNum;
                colNum = this.referencedCols.anySetBit(colNum);
            }
        }
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(hashKeyCols);
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        long conglomNumber = cd.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(conglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(conglomNumber);
        mb.push(acb.addItem(scoci));
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false)));
        mb.push(this.getResultSetNumber());
        mb.push(hashKeyItem);
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(org.apache.derby.iapi.util.PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(cd.isConstraint());
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEst.singleScanRowCount());
        mb.push(costEst.getEstimatedCost());
        mb.callMethod((short)185, null, "getDistinctScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 16);
    }

    private void generateRefActionDependentTableScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.push(this.raParentResultSetId);
        mb.push(this.fkIndexConglomId);
        mb.push(acb.addItem(this.fkColArray));
        mb.push(acb.addItem(this.getDataDictionary().getRowLocationTemplate(this.getLanguageConnectionContext(), this.tableDescriptor)));
        int argCount = nargs + 4;
        mb.callMethod((short)185, null, "getRaDependentTableScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", argCount);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    private int getScanArguments(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        AccessPath ap;
        JoinStrategy trulyTheBestJoinStrategy;
        ConglomerateDescriptor cd;
        int resultRowTemplate = acb.addItem(this.getResultColumns().buildRowTemplate(this.referencedCols, false));
        int colRefItem = -1;
        if (this.referencedCols != null) {
            colRefItem = acb.addItem(this.referencedCols);
        }
        int indexColItem = -1;
        if ((this.isCursorTargetTable() || this.getUpdateLocks) && (cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor()).isIndex()) {
            int[] baseColPos = cd.getIndexDescriptor().baseColumnPositions();
            boolean[] isAscending = cd.getIndexDescriptor().isAscending();
            int[] indexCols = new int[baseColPos.length];
            for (int i = 0; i < indexCols.length; ++i) {
                indexCols[i] = isAscending[i] ? baseColPos[i] : -baseColPos[i];
            }
            indexColItem = acb.addItem(indexCols);
        }
        if (!(trulyTheBestJoinStrategy = (ap = this.getTrulyTheBestAccessPath()).getJoinStrategy()).bulkFetchOK() && this.bulkFetch != -1) {
            SanityManager.THROWASSERT("bulkFetch should not be set for the join strategy " + trulyTheBestJoinStrategy.getName());
        }
        int nargs = trulyTheBestJoinStrategy.getScanArgs(this.getLanguageConnectionContext().getTransactionCompile(), mb, this, this.storeRestrictionList, this.nonStoreRestrictionList, acb, this.bulkFetch, resultRowTemplate, colRefItem, indexColItem, this.getTrulyTheBestAccessPath().getLockMode(), this.tableDescriptor.getLockGranularity() == 'T', this.getCompilerContext().getScanIsolationLevel(), ap.getOptimizer().getMaxMemoryPerTable(), this.multiProbing);
        return nargs;
    }

    private int mapAbsoluteToRelativeColumnPosition(int absolutePosition) {
        if (this.referencedCols == null) {
            return absolutePosition;
        }
        int setBitCtr = 0;
        for (int bitCtr = 0; bitCtr < this.referencedCols.size() && bitCtr < absolutePosition; ++bitCtr) {
            if (!this.referencedCols.get(bitCtr)) continue;
            ++setBitCtr;
        }
        return setBitCtr;
    }

    @Override
    String getExposedName() {
        if (this.correlationName != null) {
            return this.correlationName;
        }
        return this.getOrigTableName().getFullTableName();
    }

    TableName getExposedTableName() throws StandardException {
        if (this.correlationName != null) {
            return this.makeTableName(null, this.correlationName);
        }
        return this.getOrigTableName();
    }

    TableName getTableNameField() {
        return this.tableName;
    }

    @Override
    ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        return this.getResultColumnsForList(allTableName, this.getResultColumns(), this.getOrigTableName());
    }

    ResultColumnList genResultColList() throws StandardException {
        TableName exposedName = this.getExposedTableName();
        ResultColumnList rcList = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor colDesc = cdl.elementAt(index);
            colDesc.setTableDescriptor(this.tableDescriptor);
            BaseColumnNode valueNode = new BaseColumnNode(colDesc.getColumnName(), exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(colDesc, (ValueNode)valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        if (this.rowLocationColumnName != null) {
            CurrentRowLocationNode rowLocationNode = new CurrentRowLocationNode(this.getContextManager());
            ResultColumn rowLocationColumn = new ResultColumn(this.rowLocationColumnName, (ValueNode)rowLocationNode, this.getContextManager());
            rowLocationColumn.markGenerated();
            rowLocationNode.bindExpression(null, null, null);
            rowLocationColumn.bindResultColumnToExpression();
            rcList.addResultColumn(rowLocationColumn);
        }
        return rcList;
    }

    ResultColumnList addColsToList(ResultColumnList inputRcl, FormatableBitSet colsWeWant) throws StandardException {
        TableName exposedName = this.getExposedTableName();
        ResultColumnList newRcl = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            int position = cd.getPosition();
            if (!colsWeWant.get(position)) continue;
            ResultColumn resultColumn = inputRcl.getResultColumn(position);
            if (resultColumn == null) {
                ColumnReference cr = new ColumnReference(cd.getColumnName(), exposedName, this.getContextManager());
                if (this.getMergeTableID() != 0) {
                    cr.setMergeTableID(this.getMergeTableID());
                }
                resultColumn = new ResultColumn(cd, (ValueNode)cr, this.getContextManager());
            }
            newRcl.addResultColumn(resultColumn);
        }
        return newRcl;
    }

    @Override
    TableName getTableName() throws StandardException {
        TableName tn = super.getTableName();
        if (tn != null && tn.getSchemaName() == null && this.correlationName == null) {
            tn.bind();
        }
        return tn != null ? tn : this.tableName;
    }

    @Override
    boolean markAsCursorTargetTable() {
        this.setCursorTargetTable(true);
        return true;
    }

    @Override
    protected boolean cursorTargetTable() {
        return this.isCursorTargetTable();
    }

    void markUpdated(ResultColumnList updateColumns) {
        this.getResultColumns().markUpdated(updateColumns);
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return baseTable && name.equals(this.getBaseTableName());
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.tableDescriptor.getSchemaDescriptor());
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        if (this.existsBaseTable) {
            return true;
        }
        AccessPath ap = this.getTrulyTheBestAccessPath();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        if (trulyTheBestJoinStrategy.isHashJoin()) {
            PredicateList pl = new PredicateList(this.getContextManager());
            if (this.storeRestrictionList != null) {
                pl.nondestructiveAppend(this.storeRestrictionList);
            }
            if (this.nonStoreRestrictionList != null) {
                pl.nondestructiveAppend(this.nonStoreRestrictionList);
            }
            return this.isOneRowResultSet(pl);
        }
        return this.isOneRowResultSet(this.getTrulyTheBestAccessPath().getConglomerateDescriptor(), this.restrictionList);
    }

    @Override
    boolean isNotExists() {
        return this.isNotExists;
    }

    boolean isOneRowResultSet(OptimizablePredicateList predList) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            if (!this.isOneRowResultSet(cds[index], predList)) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(boolean[] eqCols) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            int inner;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            for (inner = 0; inner < keyColumns.length && eqCols[keyColumns[inner]]; ++inner) {
            }
            if (inner != keyColumns.length) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(JBitSet[] tableColMap) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            int numBits = tableColMap[0].size();
            JBitSet keyMap = new JBitSet(numBits);
            JBitSet resMap = new JBitSet(numBits);
            for (int inner = 0; inner < keyColumns.length; ++inner) {
                keyMap.set(keyColumns[inner]);
            }
            for (int table = 0; table < tableColMap.length; ++table) {
                resMap.setTo(tableColMap[table]);
                resMap.and(keyMap);
                if (!keyMap.equals(resMap)) continue;
                tableColMap[table].set(0);
                return true;
            }
        }
        return false;
    }

    @Override
    int updateTargetLockMode() {
        if (this.getTrulyTheBestAccessPath().getConglomerateDescriptor().isIndex()) {
            return 6;
        }
        int isolationLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        if (isolationLevel != 4 && this.tableDescriptor.getLockGranularity() != 'T') {
            int lockMode = this.getTrulyTheBestAccessPath().getLockMode();
            lockMode = lockMode != 6 ? (lockMode & 0xFF) << 16 : 0;
            return lockMode += 6;
        }
        return this.getTrulyTheBestAccessPath().getLockMode();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) throws StandardException {
        for (int index = 0; index < crs.length; ++index) {
            if (crs[index].getTableNumber() == this.tableNumber) continue;
            return false;
        }
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (!cd.isIndex()) {
            return false;
        }
        boolean isOrdered = permuteOrdering ? this.isOrdered(crs, cd) : this.isStrictlyOrdered(crs, cd);
        if (fbtHolder != null) {
            fbtHolder.add(this);
        }
        return isOrdered;
    }

    void disableBulkFetch() {
        this.bulkFetchTurnedOff = true;
        this.bulkFetch = -1;
    }

    void doSpecialMaxScan() {
        if (this.restrictionList.size() != 0 || this.storeRestrictionList.size() != 0 || this.nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT("shouldn't be setting max special scan because there is a restriction");
        }
        this.specialMaxScan = true;
    }

    @Override
    boolean isPossibleDistinctScan(Set<BaseColumnNode> distinctColumns) {
        if (this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<ValueNode> columns = new HashSet<ValueNode>();
        for (ResultColumn rc : this.getResultColumns()) {
            columns.add(rc.getExpression());
        }
        return columns.equals(distinctColumns);
    }

    @Override
    void markForDistinctScan() {
        this.distinctScan = true;
    }

    @Override
    void adjustForSortElimination() {
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        if (this.restrictionList != null) {
            this.restrictionList.adjustForSortElimination(rowOrdering);
        }
    }

    private boolean isOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextCR;
        int nextKeyColumn;
        boolean[] matchedCRs = new boolean[crs.length];
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        for (nextKeyColumn = 0; nextKeyColumn < keyColumns.length; ++nextKeyColumn) {
            boolean currMatch = false;
            for (nextCR = 0; nextCR < crs.length; ++nextCR) {
                if (crs[nextCR].getColumnNumber() != keyColumns[nextKeyColumn]) continue;
                matchedCRs[nextCR] = true;
                currMatch = true;
                break;
            }
            if (!currMatch && !this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) break;
        }
        int numCRsMatched = 0;
        for (nextCR = 0; nextCR < matchedCRs.length; ++nextCR) {
            if (!matchedCRs[nextCR]) continue;
            ++numCRsMatched;
        }
        if (numCRsMatched == matchedCRs.length) {
            return true;
        }
        if (nextKeyColumn == keyColumns.length) {
            return cd.getIndexDescriptor().isUnique();
        }
        return false;
    }

    private boolean isStrictlyOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextKeyColumn = 0;
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        block0: for (int nextCR = 0; nextCR < crs.length; ++nextCR) {
            if (nextKeyColumn == keyColumns.length) {
                if (cd.getIndexDescriptor().isUnique()) break;
                return false;
            }
            if (crs[nextCR].getColumnNumber() == keyColumns[nextKeyColumn]) {
                ++nextKeyColumn;
                continue;
            }
            while (crs[nextCR].getColumnNumber() != keyColumns[nextKeyColumn]) {
                if (!this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) {
                    return false;
                }
                if (++nextKeyColumn != keyColumns.length) continue;
                if (cd.getIndexDescriptor().isUnique()) continue block0;
                return false;
            }
        }
        return true;
    }

    private boolean isOneRowResultSet(ConglomerateDescriptor cd, OptimizablePredicateList predList) throws StandardException {
        if (predList == null) {
            return false;
        }
        if (!(predList instanceof PredicateList)) {
            SanityManager.THROWASSERT("predList should be a PredicateList, but is a " + predList.getClass().getName());
        }
        PredicateList restrictList = (PredicateList)predList;
        if (!cd.isIndex()) {
            return false;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        if (!irg.isUnique()) {
            return false;
        }
        int[] baseColumnPositions = irg.baseColumnPositions();
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            int curCol = baseColumnPositions[index];
            if (restrictList.hasOptimizableEqualityPredicate(this, curCol, true)) continue;
            return false;
        }
        return true;
    }

    private int getDefaultBulkFetch() throws StandardException {
        String valStr = PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.language.bulkFetchDefault", "16");
        int valInt = this.getIntProperty(valStr, "derby.language.bulkFetchDefault");
        if (valInt <= 0) {
            throw StandardException.newException("42Y64", String.valueOf(valInt));
        }
        return valInt <= 1 ? -1 : valInt;
    }

    private String getUserSpecifiedIndexName() {
        String retval = null;
        if (this.tableProperties != null) {
            retval = this.tableProperties.getProperty("index");
        }
        return retval;
    }

    private StoreCostController getStoreCostController(ConglomerateDescriptor cd) throws StandardException {
        return this.getCompilerContext().getStoreCostController(cd.getConglomerateNumber());
    }

    private StoreCostController getBaseCostController() throws StandardException {
        return this.getStoreCostController(this.baseConglomerateDescriptor);
    }

    private long baseRowCount() throws StandardException {
        if (!this.gotRowCount) {
            StoreCostController scc = this.getBaseCostController();
            this.rowCount = scc.getEstimatedRowCount();
            this.gotRowCount = true;
        }
        return this.rowCount;
    }

    private DataValueDescriptor[] getRowTemplate(ConglomerateDescriptor cd, StoreCostController scc) throws StandardException {
        if (!cd.isIndex()) {
            return this.templateColumns.buildEmptyRow().getRowArray();
        }
        ExecRow emptyIndexRow = this.templateColumns.buildEmptyIndexRow(this.tableDescriptor, cd, scc, this.getDataDictionary());
        return emptyIndexRow.getRowArray();
    }

    private ConglomerateDescriptor getFirstConglom() throws StandardException {
        this.getConglomDescs();
        return this.conglomDescs[0];
    }

    private ConglomerateDescriptor getNextConglom(ConglomerateDescriptor currCD) {
        int index;
        for (index = 0; index < this.conglomDescs.length && currCD != this.conglomDescs[index]; ++index) {
        }
        if (index < this.conglomDescs.length - 1) {
            return this.conglomDescs[index + 1];
        }
        return null;
    }

    private void getConglomDescs() throws StandardException {
        if (this.conglomDescs == null) {
            this.conglomDescs = this.tableDescriptor.getConglomerateDescriptors();
        }
    }

    @Override
    void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.fkIndexConglomId = fkIndexConglomId;
        this.fkColArray = fkColArray;
        this.raParentResultSetId = parentResultSetId;
        this.raDependentScan = dependentScan;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.nonStoreRestrictionList != null) {
            this.nonStoreRestrictionList.accept(v);
        }
        if (this.restrictionList != null) {
            this.restrictionList.accept(v);
        }
        if (this.nonBaseTableRestrictionList != null) {
            this.nonBaseTableRestrictionList.accept(v);
        }
        if (this.requalificationRestrictionList != null) {
            this.requalificationRestrictionList.accept(v);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(v);
        }
    }

    private boolean qualifiesForStatisticsUpdateCheck(TableDescriptor td) throws StandardException {
        int qualifiedIndexes = 0;
        if (td.getTableType() == 0) {
            IndexStatisticsDaemonImpl istatDaemon = (IndexStatisticsDaemonImpl)this.getDataDictionary().getIndexStatsRefresher(false);
            qualifiedIndexes = istatDaemon == null ? 0 : (istatDaemon.skipDisposableStats ? td.getQualifiedNumberOfIndexes(2, true) : td.getTotalNumberOfIndexes());
        }
        return qualifiedIndexes > 0;
    }
}

