/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.ProductVersionHolder;

public final class FileMonitor
extends BaseMonitor {
    private File home;
    private ProductVersionHolder engineVersion;
    private static final Map<String, Void> securityProperties = new HashMap<String, Void>();

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintWriter log) {
        this.runWithState(properties, log);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File sr = new File(this.home, "derby.properties");
        if (!sr.exists()) {
            return null;
        }
        return new FileInputStream(sr);
    }

    @Override
    public Object getEnvironment() {
        return this.home;
    }

    private ThreadGroup createDaemonGroup() {
        try {
            ThreadGroup group = new ThreadGroup("derby.daemons");
            group.setDaemon(true);
            return group;
        }
        catch (SecurityException se) {
            this.reportThread(se);
            return null;
        }
    }

    private boolean PBinitialize(boolean lite) {
        String systemHome;
        if (!lite) {
            this.daemonGroup = this.createDaemonGroup();
        }
        InputStream versionStream = this.getClass().getResourceAsStream("/org/apache/derby/info/engine/info.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(versionStream);
        try {
            systemHome = System.getProperty("derby.system.home");
        }
        catch (SecurityException se) {
            this.report(se, "derby.system.home");
            systemHome = null;
        }
        if (systemHome != null) {
            this.home = new File(systemHome);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + systemHome + " does not represent a directory");
                    return false;
                }
            } else if (!lite) {
                boolean created = false;
                try {
                    boolean bl = created = this.home.mkdir() || this.home.mkdirs();
                    if (created) {
                        FileUtil.limitAccessToOwner(this.home);
                    }
                }
                catch (SecurityException se) {
                    this.report(se, this.home);
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException se) {
            this.report(se, key);
            return null;
        }
    }

    private void report(SecurityException e, String key) {
        if (securityProperties.containsKey(key)) {
            this.report(MessageService.getTextMessage("M008", key, e.toString()));
        }
    }

    private void report(SecurityException e, File file) {
        this.report(MessageService.getTextMessage("M009", file.toString(), e.toString()));
    }

    private void reportThread(SecurityException e) {
        this.report(MessageService.getTextMessage("M010", e.toString()));
    }

    @Override
    final boolean initialize(final boolean lite) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileMonitor.this.PBinitialize(lite);
            }
        });
    }

    @Override
    final Properties getDefaultModuleProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return FileMonitor.super.getDefaultModuleProperties();
            }
        });
    }

    @Override
    public final String getJVMProperty(final String key) {
        if (!key.startsWith("derby.")) {
            return this.PBgetJVMProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FileMonitor.this.PBgetJVMProperty(key);
            }
        });
    }

    @Override
    public final synchronized Thread getDaemonThread(final Runnable task, final String name, final boolean setMinPriority) {
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                try {
                    return FileMonitor.super.getDaemonThread(task, name, setMinPriority);
                }
                catch (IllegalThreadStateException e) {
                    if (FileMonitor.this.daemonGroup != null && FileMonitor.this.daemonGroup.isDestroyed()) {
                        FileMonitor.this.daemonGroup = FileMonitor.this.createDaemonGroup();
                        return FileMonitor.super.getDaemonThread(task, name, setMinPriority);
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    final InputStream applicationPropertiesStream() throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return FileMonitor.this.PBapplicationPropertiesStream();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    @Override
    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }

    static {
        securityProperties.put("derby.authentication.builtin.algorithm", null);
        securityProperties.put("derby.authentication.provider", null);
        securityProperties.put("derby.database.fullAccessUsers", null);
        securityProperties.put("derby.database.readOnlyAccessUsers", null);
        securityProperties.put("derby.database.sqlAuthorization", null);
        securityProperties.put("derby.connection.requireAuthentication", null);
        securityProperties.put("derby.database.defaultConnectionMode", null);
        securityProperties.put("derby.storage.useDefaultFilePermissions", null);
        securityProperties.put("derby.system.home", null);
    }
}

