/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.io.Serializable;

public final class ValueWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ValueWrapper nullValueWrapper = new ValueWrapper(null);
    private final Serializable value;
    private final Class<?> type;
    private final String stringRepresentation;
    private final int identityHashCode;
    private final transient Object ephemeralValue;

    public static ValueWrapper create(Object value) {
        if (value instanceof ValueWrapper) {
            return (ValueWrapper)value;
        }
        return value == null ? nullValueWrapper : new ValueWrapper(value);
    }

    public static ValueWrapper create(Object value, String stringRepresentation) {
        if (value instanceof ValueWrapper) {
            ValueWrapper wrapper = (ValueWrapper)value;
            return wrapper.stringRepresentation.equals(stringRepresentation) ? wrapper : ValueWrapper.create(wrapper.value, stringRepresentation);
        }
        return value == null ? nullValueWrapper : new ValueWrapper(value, stringRepresentation);
    }

    private ValueWrapper(Object value, String stringRepresentation) {
        this.value = value instanceof Serializable ? (Serializable)value : null;
        this.type = value != null ? value.getClass() : null;
        this.stringRepresentation = stringRepresentation == null ? ValueWrapper.safeValueToString(value) : stringRepresentation;
        this.identityHashCode = System.identityHashCode(value);
        this.ephemeralValue = value;
    }

    private ValueWrapper(Object value) {
        this(value, ValueWrapper.safeValueToString(value));
    }

    private static String safeValueToString(Object value) {
        try {
            return String.valueOf(value);
        }
        catch (Exception e) {
            return "<Exception in toString(): " + e + ">";
        }
    }

    public Serializable getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public Object getEphemeralValue() {
        return this.ephemeralValue;
    }

    public String toString() {
        if (this.type == null) {
            return "null";
        }
        return this.stringRepresentation + " (" + this.type.getName() + "@" + Integer.toHexString(this.identityHashCode) + ")";
    }
}

