/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOTriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOTriConsumerTest {
    IOTriConsumerTest() {
    }

    @Test
    void testAccept() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOTriConsumer consumer = (s, i, b) -> ref.set(s + i + b);
        consumer.accept((Object)"A", (Object)1, (Object)Character.valueOf('b'));
        Assertions.assertEquals((Object)"A1b", ref.get());
    }

    @Test
    void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOTriConsumer consumer1 = (s, i, b) -> ref.set(s + i + b);
        IOTriConsumer consumer2 = (s, i, b) -> ref.set((String)ref.get() + b + i + s);
        consumer1.andThen(consumer2).accept((Object)"B", (Object)2, (Object)Character.valueOf('b'));
        Assertions.assertEquals((Object)"B2bb2B", ref.get());
    }

    @Test
    void testNoop() throws IOException {
        IOTriConsumer.noop().accept(null, null, null);
    }
}

