/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StateMachine
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(StateMachine.class);

    default public DataApi data() {
        return this instanceof DataApi ? (DataApi)((Object)this) : DataApi.DEFAULT;
    }

    default public EventApi event() {
        return this instanceof EventApi ? (EventApi)((Object)this) : EventApi.DEFAULT;
    }

    default public LeaderEventApi leaderEvent() {
        return this instanceof LeaderEventApi ? (LeaderEventApi)((Object)this) : LeaderEventApi.DEFAULT;
    }

    default public FollowerEventApi followerEvent() {
        return this instanceof FollowerEventApi ? (FollowerEventApi)((Object)this) : FollowerEventApi.DEFAULT;
    }

    public void initialize(RaftServer var1, RaftGroupId var2, RaftStorage var3) throws IOException;

    public LifeCycle.State getLifeCycleState();

    public void pause();

    public void reinitialize() throws IOException;

    public long takeSnapshot() throws IOException;

    public StateMachineStorage getStateMachineStorage();

    public SnapshotInfo getLatestSnapshot();

    public CompletableFuture<Message> query(Message var1);

    public CompletableFuture<Message> queryStale(Message var1, long var2);

    public TransactionContext startTransaction(RaftClientRequest var1) throws IOException;

    default public TransactionContext startTransaction(RaftProtos.LogEntryProto entry, RaftProtos.RaftPeerRole role) {
        return TransactionContext.newBuilder().setStateMachine(this).setLogEntry(entry).setServerRole(role).build();
    }

    public TransactionContext preAppendTransaction(TransactionContext var1) throws IOException;

    public TransactionContext cancelTransaction(TransactionContext var1) throws IOException;

    public TransactionContext applyTransactionSerial(TransactionContext var1) throws InvalidProtocolBufferException;

    public CompletableFuture<Message> applyTransaction(TransactionContext var1);

    public TermIndex getLastAppliedTermIndex();

    default public String toStateMachineLogEntryString(RaftProtos.StateMachineLogEntryProto proto) {
        return JavaUtils.getClassSimpleName(proto.getClass()) + ":" + ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)proto);
    }

    public static interface DataStream {
        public DataChannel getDataChannel();

        public CompletableFuture<?> cleanUp();

        default public Executor getExecutor() {
            return null;
        }
    }

    public static interface DataChannel
    extends WritableByteChannel {
        @Override
        default public int write(ByteBuffer buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public int write(ReferenceCountedObject<ByteBuffer> referenceCountedBuffer) throws IOException {
            return this.write((ByteBuffer)referenceCountedBuffer.get());
        }

        public void force(boolean var1) throws IOException;
    }

    public static interface FollowerEventApi {
        public static final FollowerEventApi DEFAULT = new FollowerEventApi(){};

        default public void notifyExtendedNoLeader(RaftProtos.RoleInfoProto roleInfoProto) {
        }

        default public CompletableFuture<TermIndex> notifyInstallSnapshotFromLeader(RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static interface LeaderEventApi {
        public static final LeaderEventApi DEFAULT = new LeaderEventApi(){};

        default public void notifyFollowerSlowness(RaftProtos.RoleInfoProto leaderInfo, RaftPeer slowFollower) {
        }

        @Deprecated
        default public void notifyFollowerSlowness(RaftProtos.RoleInfoProto leaderInfo) {
        }

        default public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
        }

        default public void notifyLeaderReady() {
        }
    }

    public static interface EventApi {
        public static final EventApi DEFAULT = new EventApi(){};

        default public void notifyLeaderChanged(RaftGroupMemberId groupMemberId, RaftPeerId newLeaderId) {
        }

        default public void notifyTermIndexUpdated(long term, long index) {
        }

        default public void notifyConfigurationChanged(long term, long index, RaftProtos.RaftConfigurationProto newRaftConfiguration) {
        }

        default public void notifyGroupRemove() {
        }

        default public void notifyLogFailed(Throwable cause, RaftProtos.LogEntryProto failedEntry) {
        }

        default public void notifySnapshotInstalled(RaftProtos.InstallSnapshotResult result, long snapshotIndex, RaftPeer peer) {
        }

        default public void notifyServerShutdown(RaftProtos.RoleInfoProto roleInfo) {
        }
    }

    public static interface DataApi {
        public static final DataApi DEFAULT = new DataApi(){};

        default public CompletableFuture<ByteString> read(RaftProtos.LogEntryProto entry) {
            throw new UnsupportedOperationException("This method is NOT supported.");
        }

        default public CompletableFuture<ByteString> read(RaftProtos.LogEntryProto entry, TransactionContext context) {
            return this.read(entry);
        }

        default public CompletableFuture<?> write(RaftProtos.LogEntryProto entry) {
            return CompletableFuture.completedFuture(null);
        }

        default public CompletableFuture<?> write(RaftProtos.LogEntryProto entry, TransactionContext context) {
            return this.write(entry);
        }

        default public CompletableFuture<DataStream> stream(RaftClientRequest request) {
            return CompletableFuture.completedFuture(null);
        }

        default public CompletableFuture<?> link(DataStream stream, RaftProtos.LogEntryProto entry) {
            return CompletableFuture.completedFuture(null);
        }

        default public CompletableFuture<Void> flush(long logIndex) {
            return CompletableFuture.completedFuture(null);
        }

        default public CompletableFuture<Void> truncate(long logIndex) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static interface Registry
    extends Function<RaftGroupId, StateMachine> {
    }
}

