/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbApplicationMetaRequest;
import org.apache.celeborn.common.protocol.PbAuthenticationInitiationRequest;
import org.apache.celeborn.common.protocol.PbAuthenticationInitiationResponse;
import org.apache.celeborn.common.protocol.PbBacklogAnnouncement;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbChunkFetchRequest;
import org.apache.celeborn.common.protocol.PbGetShuffleId;
import org.apache.celeborn.common.protocol.PbGetShuffleIdResponse;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbPushDataHandShake;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbRegionFinish;
import org.apache.celeborn.common.protocol.PbRegionStart;
import org.apache.celeborn.common.protocol.PbRegisterApplicationRequest;
import org.apache.celeborn.common.protocol.PbRegisterApplicationResponse;
import org.apache.celeborn.common.protocol.PbReportBarrierStageAttemptFailure;
import org.apache.celeborn.common.protocol.PbReportBarrierStageAttemptFailureResponse;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailure;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailureResponse;
import org.apache.celeborn.common.protocol.PbSaslRequest;
import org.apache.celeborn.common.protocol.PbStreamChunkSlice;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbTransportableError;
import org.apache.celeborn.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.celeborn.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportMessage
implements Serializable {
    private static final long serialVersionUID = -3259000920699629773L;
    private static Logger logger = LoggerFactory.getLogger(TransportMessage.class);
    @Deprecated
    private final transient MessageType type;
    private final int messageTypeValue;
    private final byte[] payload;

    public TransportMessage(MessageType type, byte[] payload) {
        this.type = type;
        this.messageTypeValue = type.getNumber();
        this.payload = payload;
    }

    public MessageType getType() {
        return this.type;
    }

    public int getMessageTypeValue() {
        return this.messageTypeValue;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public <T extends GeneratedMessageV3> T getParsedPayload() throws InvalidProtocolBufferException {
        switch (this.messageTypeValue) {
            case 51: {
                return (T)PbOpenStream.parseFrom(this.payload);
            }
            case 52: {
                return (T)PbStreamHandler.parseFrom(this.payload);
            }
            case 56: {
                return (T)PbPushDataHandShake.parseFrom(this.payload);
            }
            case 57: {
                return (T)PbRegionStart.parseFrom(this.payload);
            }
            case 58: {
                return (T)PbRegionFinish.parseFrom(this.payload);
            }
            case 59: {
                return (T)PbBacklogAnnouncement.parseFrom(this.payload);
            }
            case 60: {
                return (T)PbBufferStreamEnd.parseFrom(this.payload);
            }
            case 61: {
                return (T)PbReadAddCredit.parseFrom(this.payload);
            }
            case 62: {
                return (T)PbStreamChunkSlice.parseFrom(this.payload);
            }
            case 63: {
                return (T)PbChunkFetchRequest.parseFrom(this.payload);
            }
            case 64: {
                return (T)PbTransportableError.parseFrom(this.payload);
            }
            case 69: {
                return (T)PbGetShuffleId.parseFrom(this.payload);
            }
            case 70: {
                return (T)PbGetShuffleIdResponse.parseFrom(this.payload);
            }
            case 67: {
                return (T)PbReportShuffleFetchFailure.parseFrom(this.payload);
            }
            case 68: {
                return (T)PbReportShuffleFetchFailureResponse.parseFrom(this.payload);
            }
            case 83: {
                return (T)PbReportBarrierStageAttemptFailure.parseFrom(this.payload);
            }
            case 84: {
                return (T)PbReportBarrierStageAttemptFailureResponse.parseFrom(this.payload);
            }
            case 71: {
                return (T)PbSaslRequest.parseFrom(this.payload);
            }
            case 72: {
                return (T)PbAuthenticationInitiationRequest.parseFrom(this.payload);
            }
            case 73: {
                return (T)PbAuthenticationInitiationResponse.parseFrom(this.payload);
            }
            case 74: {
                return (T)PbRegisterApplicationRequest.parseFrom(this.payload);
            }
            case 75: {
                return (T)PbRegisterApplicationResponse.parseFrom(this.payload);
            }
            case 78: {
                return (T)PbApplicationMeta.parseFrom(this.payload);
            }
            case 79: {
                return (T)PbApplicationMetaRequest.parseFrom(this.payload);
            }
            case 80: {
                return (T)PbOpenStreamList.parseFrom(this.payload);
            }
            case 81: {
                return (T)PbOpenStreamListResponse.parseFrom(this.payload);
            }
        }
        logger.error("Unexpected type {}", (Object)this.type);
        return null;
    }

    public ByteBuffer toByteBuffer() {
        int totalBufferSize = this.payload.length + 4 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(totalBufferSize);
        buffer.putInt(this.messageTypeValue);
        buffer.putInt(this.payload.length);
        buffer.put(this.payload);
        buffer.flip();
        return buffer;
    }

    public static TransportMessage fromByteBuffer(ByteBuffer buffer) throws CelebornIOException {
        int messageTypeValue = buffer.getInt();
        if (MessageType.forNumber(messageTypeValue) == null) {
            throw new CelebornIOException("Decode failed, fallback to legacy messages.");
        }
        int payloadLen = buffer.getInt();
        byte[] payload = new byte[payloadLen];
        buffer.get(payload);
        MessageType msgType = MessageType.forNumber(messageTypeValue);
        return new TransportMessage(msgType, payload);
    }
}

