/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec!\u0002\r\u001a\u0001})\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011e\u0002!\u0011!Q\u0001\nUB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005y!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001b\u0001\n#9\u0005BB*\u0001A\u0003%\u0001\nC\u0004c\u0001\u0001\u0007I\u0011B2\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"1a\u000e\u0001Q!\n\u0011Dq\u0001\u001d\u0001A\u0002\u0013%1\rC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\rQ\u0004\u0001\u0015)\u0003e\u0011\u001d1\b\u00011A\u0005\n]Dqa\u001f\u0001A\u0002\u0013%A\u0010\u0003\u0004\u007f\u0001\u0001\u0006K\u0001\u001f\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\u0006\u0001\t\u0003\tI\u0002\u0003\u0004\u0002\u001c\u0001!\ta\u0019\u0005\b\u0003;\u0001A\u0011CA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAa!a\u0014\u0001\t\u00039(!B%oE>D(B\u0001\u000e\u001c\u0003\u0015qW\r\u001e;z\u0015\taR$A\u0002sa\u000eT!AH\u0010\u0002\r\r|W.\\8o\u0015\t\u0001\u0013%\u0001\u0005dK2,'m\u001c:o\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Aj\u0011A\f\u0006\u0003_u\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003c9\u0012q\u0001T8hO&tw-A\u0006f]\u0012\u0004x.\u001b8u%\u001647\u0001A\u000b\u0002kA\u0011agN\u0007\u00023%\u0011\u0001(\u0007\u0002\u0014\u001d\u0016$H/\u001f*qG\u0016sG\r]8j]R\u0014VMZ\u0001\rK:$\u0007o\\5oiJ+g\rI\u0001\tK:$\u0007o\\5oiV\tA\b\u0005\u0002>}5\t1$\u0003\u0002@7\tY!\u000b]2F]\u0012\u0004x.\u001b8u\u0003%)g\u000e\u001a9pS:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u0012+\u0005C\u0001\u001c\u0001\u0011\u0015\u0011T\u00011\u00016\u0011\u0015QT\u00011\u0001=\u0003!iWm]:bO\u0016\u001cX#\u0001%\u0011\u0007%s\u0005+D\u0001K\u0015\tYE*\u0001\u0003vi&d'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013!\u0002T5oW\u0016$G*[:u!\t1\u0014+\u0003\u0002S3\ta\u0011J\u001c2pq6+7o]1hK\u0006IQ.Z:tC\u001e,7\u000f\t\u0015\u0005\u000fU{\u0006\r\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i[\u0016AC1o]>$\u0018\r^5p]*\tA,A\u0003kCZ\f\u00070\u0003\u0002_/\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002C\u0006!A\u000f[5t\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012\u0001\u001a\t\u0003O\u0015L!A\u001a\u0015\u0003\u000f\t{w\u000e\\3b]\u0006Y1\u000f^8qa\u0016$w\fJ3r)\tIG\u000e\u0005\u0002(U&\u00111\u000e\u000b\u0002\u0005+:LG\u000fC\u0004n\u0013\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\u0011QQk\u00181\u0002!\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$\u0018\u0001F3oC\ndWmQ8oGV\u0014(/\u001a8u?\u0012*\u0017\u000f\u0006\u0002jg\"9Q\u000eDA\u0001\u0002\u0004!\u0017!E3oC\ndWmQ8oGV\u0014(/\u001a8uA!\"Q\"V0a\u0003AqW/\\!di&4X\r\u00165sK\u0006$7/F\u0001y!\t9\u00130\u0003\u0002{Q\t\u0019\u0011J\u001c;\u0002)9,X.Q2uSZ,G\u000b\u001b:fC\u0012\u001cx\fJ3r)\tIW\u0010C\u0004n\u001f\u0005\u0005\t\u0019\u0001=\u0002#9,X.Q2uSZ,G\u000b\u001b:fC\u0012\u001c\b\u0005\u000b\u0003\u0011+~\u0003\u0017a\u00029s_\u000e,7o\u001d\u000b\u0004S\u0006\u0015\u0001bBA\u0004#\u0001\u0007\u0011\u0011B\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\bc\u0001\u001c\u0002\f%\u0019\u0011QB\r\u0003\u0015\u0011K7\u000f]1uG\",'/\u0001\u0003q_N$HcA5\u0002\u0014!1\u0011Q\u0003\nA\u0002A\u000bq!\\3tg\u0006<W-\u0001\u0003ti>\u0004H#A5\u0002\u000f%\u001cX)\u001c9us\u00061qN\u001c#s_B$2![A\u0011\u0011\u0019\t)\"\u0006a\u0001!\u0006Q1/\u00194fYf\u001c\u0015\r\u001c7\u0015\r\u0005\u001d\u00121GA\u001b)\rI\u0017\u0011\u0006\u0005\t\u0003W1B\u00111\u0001\u0002.\u00051\u0011m\u0019;j_:\u0004BaJA\u0018S&\u0019\u0011\u0011\u0007\u0015\u0003\u0011q\u0012\u0017P\\1nKzBQA\u000f\fA\u0002qBq!a\u000e\u0017\u0001\u0004\tI$A\bf]\u0012\u0004x.\u001b8u%\u00164g*Y7f!\u0011\tY$!\u0013\u000f\t\u0005u\u0012Q\t\t\u0004\u0003\u007fASBAA!\u0015\r\t\u0019eM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\niE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fB\u0013aE4fi:+X.Q2uSZ,G\u000b\u001b:fC\u0012\u001c\b")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), this.endpointRef().name(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    BoxedUnit boxedUnit;
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        boxedUnit = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit boxedUnit = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                } else if (OnStart$.MODULE$.equals(inboxMessage)) {
                    BoxedUnit boxedUnit;
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)inboxMessage);
                }
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, String endpointRefName, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        BoxedUnit boxedUnit2;
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit2;
                    } else if (throwable4 != null) {
                        Throwable throwable5 = throwable4;
                        this.dealWithFatalError$1(throwable5, endpointRefName);
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        throw throwable3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                this.dealWithFatalError$1(throwable6, endpointRefName);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public synchronized int getNumActiveThreads() {
        return this.numActiveThreads();
    }

    private final void dealWithFatalError$1(Throwable fatal, String endpointRefName$1) {
        Inbox inbox = this;
        synchronized (inbox) {
            Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0 & Serializable & scala.Serializable)() -> "The number of active threads should be positive.");
            this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("An error happened while processing message in the inbox for ").append(endpointRefName$1).toString(), fatal);
        throw fatal;
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

