/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.service.deploy.worker.memory.BufferQueue;
import org.apache.celeborn.service.deploy.worker.memory.BufferRecycler;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.MapDataPartitionReader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapDataPartition
implements MemoryManager.ReadBufferTargetChangeListener {
    public static final Logger logger = LoggerFactory.getLogger(MapDataPartition.class);
    private final FileInfo fileInfo;
    private final ExecutorService readExecutor;
    private final ConcurrentHashMap<Long, MapDataPartitionReader> readers = JavaUtils.newConcurrentHashMap();
    private FileChannel dataFileChanel;
    private FileChannel indexChannel;
    private long indexSize;
    private volatile boolean isReleased = false;
    private final BufferQueue bufferQueue = new BufferQueue();
    private AtomicBoolean bufferQueueInitialized = new AtomicBoolean(false);
    private MemoryManager memoryManager = MemoryManager.instance();
    private Consumer<Long> recycleStream;
    private int minReadBuffers;
    private int maxReadBuffers;
    private int minBuffersToTriggerRead;
    private AtomicBoolean hasReadingTask = new AtomicBoolean(false);

    public MapDataPartition(int minReadBuffers, int maxReadBuffers, HashMap<String, ExecutorService> storageFetcherPool, int threadsPerMountPoint, FileInfo fileInfo, Consumer<Long> recycleStream, int minBuffersToTriggerRead) throws IOException {
        this.recycleStream = recycleStream;
        this.fileInfo = fileInfo;
        this.minReadBuffers = minReadBuffers;
        this.maxReadBuffers = maxReadBuffers;
        this.updateBuffersTarget((this.minReadBuffers + this.maxReadBuffers) / 2 + 1);
        logger.debug("read map partition {} with {} {}", new Object[]{fileInfo.getFilePath(), this.bufferQueue.getLocalBuffersTarget(), fileInfo.getBufferSize()});
        this.minBuffersToTriggerRead = minBuffersToTriggerRead;
        this.readExecutor = storageFetcherPool.computeIfAbsent(fileInfo.getMountPoint(), k -> Executors.newFixedThreadPool(threadsPerMountPoint, new ThreadFactoryBuilder().setNameFormat(fileInfo.getMountPoint() + "-reader-thread-%d").setUncaughtExceptionHandler((t1, t2) -> logger.warn("StorageFetcherPool thread:{}:{}", (Object)t1, (Object)t2)).build()));
        this.dataFileChanel = FileChannelUtils.openReadableFileChannel((String)fileInfo.getFilePath());
        this.indexChannel = FileChannelUtils.openReadableFileChannel((String)fileInfo.getIndexPath());
        this.indexSize = this.indexChannel.size();
        MemoryManager.instance().addReadBufferTargetChangeListener(this);
    }

    private synchronized void updateBuffersTarget(int buffersTarget) {
        int currentBuffersTarget = buffersTarget;
        if (currentBuffersTarget < this.minReadBuffers) {
            currentBuffersTarget = this.minReadBuffers;
        }
        if (currentBuffersTarget > this.maxReadBuffers) {
            currentBuffersTarget = this.maxReadBuffers;
        }
        this.bufferQueue.setLocalBuffersTarget(currentBuffersTarget);
    }

    public void setupDataPartitionReader(int startSubIndex, int endSubIndex, long streamId, Channel channel) {
        MapDataPartitionReader mapDataPartitionReader = new MapDataPartitionReader(startSubIndex, endSubIndex, this.fileInfo, streamId, channel, () -> this.recycleStream.accept(streamId));
        this.readers.put(streamId, mapDataPartitionReader);
    }

    public void tryRequestBufferOrRead() {
        if (this.bufferQueueInitialized.compareAndSet(false, true)) {
            this.bufferQueue.tryApplyNewBuffers(this.readers.size(), this.fileInfo.getBufferSize(), (allocatedBuffers, throwable) -> this.onBuffer(allocatedBuffers));
        } else {
            this.triggerRead();
        }
    }

    public void onBuffer(List<ByteBuf> buffers) {
        if (this.isReleased) {
            buffers.forEach(this.memoryManager::recycleReadBuffer);
            return;
        }
        this.bufferQueue.add(buffers);
        if (this.bufferQueue.size() >= Math.min(this.bufferQueue.getLocalBuffersTarget() / 2 + 1, this.minBuffersToTriggerRead)) {
            this.triggerRead();
        }
    }

    public void recycle(ByteBuf buffer) {
        if (this.isReleased) {
            this.memoryManager.recycleReadBuffer(buffer);
            return;
        }
        this.bufferQueue.recycle(buffer);
        if (this.bufferQueue.size() >= Math.min(this.bufferQueue.getLocalBuffersTarget() / 2 + 1, this.minBuffersToTriggerRead)) {
            this.triggerRead();
        }
        this.bufferQueue.tryApplyNewBuffers(this.readers.size(), this.fileInfo.getBufferSize(), (allocatedBuffers, throwable) -> this.onBuffer(allocatedBuffers));
    }

    public synchronized void readBuffers() {
        this.hasReadingTask.set(false);
        if (this.isReleased) {
            return;
        }
        try {
            PriorityQueue sortedReaders = new PriorityQueue(this.readers.values().stream().filter(MapDataPartitionReader::shouldReadData).collect(Collectors.toList()));
            for (MapDataPartitionReader reader : sortedReaders) {
                reader.open(this.dataFileChanel, this.indexChannel, this.indexSize);
            }
            while (this.bufferQueue.bufferAvailable() && !sortedReaders.isEmpty()) {
                MapDataPartitionReader reader;
                BufferRecycler bufferRecycler = new BufferRecycler(this::recycle);
                reader = (MapDataPartitionReader)sortedReaders.poll();
                try {
                    reader.readData(this.bufferQueue, bufferRecycler);
                }
                catch (Throwable e) {
                    logger.error("reader exception, reader: {}, message: {}", new Object[]{reader, e.getMessage(), e});
                    reader.recycleOnError(e);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Fatal: failed to read partition data. {}", (Object)e.getMessage(), (Object)e);
            for (MapDataPartitionReader reader : this.readers.values()) {
                reader.recycleOnError(e);
            }
        }
    }

    public void addReaderCredit(int numCredit, long streamId) {
        MapDataPartitionReader streamReader = this.getStreamReader(streamId);
        if (streamReader != null) {
            streamReader.addCredit(numCredit);
            this.readExecutor.submit(() -> streamReader.sendData());
        }
    }

    public void triggerRead() {
        if (this.hasReadingTask.compareAndSet(false, true)) {
            this.readExecutor.submit(() -> this.readBuffers());
        }
    }

    public MapDataPartitionReader getStreamReader(long streamId) {
        return this.readers.get(streamId);
    }

    public boolean releaseReader(Long streamId) {
        MapDataPartitionReader mapDataPartitionReader = this.readers.get(streamId);
        mapDataPartitionReader.release();
        if (mapDataPartitionReader.isFinished()) {
            logger.debug("release all for stream: {}", (Object)streamId);
            this.readers.remove(streamId);
            return true;
        }
        return false;
    }

    public void close() {
        logger.debug("release map data partition {}", (Object)this.fileInfo);
        this.bufferQueue.release();
        this.isReleased = true;
        IOUtils.closeQuietly((Closeable)this.dataFileChanel);
        IOUtils.closeQuietly((Closeable)this.indexChannel);
        MemoryManager.instance().removeReadBufferTargetChangeListener(this);
    }

    public String toString() {
        return "MapDataPartition{fileInfo=" + this.fileInfo.getFilePath() + '}';
    }

    public ConcurrentHashMap<Long, MapDataPartitionReader> getReaders() {
        return this.readers;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public void onChange(long newMemoryTarget) {
        this.updateBuffersTarget((int)Math.ceil((double)newMemoryTarget * 1.0 / (double)this.fileInfo.getBufferSize()));
        this.bufferQueue.trim();
    }
}

