/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;

public final class JitterSampler {
    public static final String PROFILE_OF_THE_THREAD = "profile of the thread";
    public static final String THREAD_HAS_BLOCKED_FOR = "thread has blocked for";
    static final long JITTER_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(Jvm.getLong("chronicle.jitter.threshold", 10L));
    static volatile String desc;
    static volatile Thread thread;
    static volatile long time;

    private JitterSampler() {
    }

    public static void atStage(String desc) {
        Jvm.startup().on(JitterSampler.class, "atStage " + desc);
        JitterSampler.desc = desc;
        thread = Thread.currentThread();
        time = System.nanoTime();
    }

    public static String takeSnapshot() {
        return JitterSampler.takeSnapshot(JITTER_THRESHOLD);
    }

    public static String takeSnapshot(long threshold) {
        long time = JitterSampler.time;
        long now = System.nanoTime();
        if (time > now - threshold) {
            return null;
        }
        Thread thread = JitterSampler.thread;
        String desc = JitterSampler.desc;
        if (thread == null || desc == null) {
            return null;
        }
        StackTraceElement[] stes = thread.getStackTrace();
        if (stes.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PROFILE_OF_THE_THREAD).append(' ').append(thread.getName()).append(' ').append(desc).append(" thread has blocked for ").append((now - time) / 1000000L).append(" ms\n");
        for (StackTraceElement ste : stes) {
            sb.append("\tat ").append(ste).append('\n');
        }
        return sb.toString();
    }

    public static void finished() {
        Jvm.startup().on(JitterSampler.class, "finished");
        thread = null;
        desc = "finished";
        time = Long.MAX_VALUE;
    }

    public static void sleepSilently(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        time = Long.MAX_VALUE;
    }
}

