/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.FrameDecoderCrc;
import org.apache.cassandra.net.FrameDecoderWith8bHeader;
import org.apache.cassandra.net.ShareableBytes;

final class FrameDecoderUnprotected
extends FrameDecoderWith8bHeader {
    FrameDecoderUnprotected(BufferPoolAllocator allocator) {
        super(allocator);
    }

    public static FrameDecoderUnprotected create(BufferPoolAllocator allocator) {
        return new FrameDecoderUnprotected(allocator);
    }

    @Override
    final long readHeader(ByteBuffer frame, int begin) {
        return FrameDecoderCrc.readHeader6b(frame, begin);
    }

    @Override
    final FrameDecoder.CorruptFrame verifyHeader(long header6b) {
        return FrameDecoderCrc.verifyHeader6b(header6b);
    }

    @Override
    final int frameLength(long header6b) {
        return FrameDecoderCrc.payloadLength(header6b) + 6;
    }

    @Override
    final FrameDecoder.Frame unpackFrame(ShareableBytes bytes, int begin, int end, long header6b) {
        boolean isSelfContained = FrameDecoderCrc.isSelfContained(header6b);
        return new FrameDecoder.IntactFrame(isSelfContained, bytes.slice(begin + 6, end));
    }

    @Override
    void decode(Collection<FrameDecoder.Frame> into, ShareableBytes bytes) {
        this.decode(into, bytes, 6);
    }

    @Override
    void addLastTo(ChannelPipeline pipeline) {
        pipeline.addLast("frameDecoderUnprotected", (ChannelHandler)this);
    }
}

