/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class AtanhCalculator
extends SeriesCalculator {
    public static final AtanhCalculator INSTANCE = new AtanhCalculator();
    private int n = 0;

    private AtanhCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return BigRational.valueOf(1, 2 * this.n + 1);
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(x, mathContext);
    }
}

