/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

public class Interval
implements Comparable<Interval> {
    public final long src;
    public final long dst;

    public Interval(long src, long dst) {
        this.src = src;
        this.dst = dst;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        if (this.dst != interval.dst) {
            return false;
        }
        return this.src == interval.src;
    }

    public int hashCode() {
        int result = (int)(this.src ^ this.src >>> 32);
        result = 31 * result + (int)(this.dst ^ this.dst >>> 32);
        return result;
    }

    @Override
    public int compareTo(Interval o) {
        int c1 = Long.compare(this.src, o.src);
        if (c1 != 0) {
            return c1;
        }
        return Long.compare(this.dst, o.dst);
    }

    public String toString() {
        return "[" + this.src + ", " + this.dst + "]";
    }
}

